document.addEventListener('DOMContentLoaded', function() {
    const listItems = document.querySelectorAll('.cwts-ul > li');
    
    // Activar el primer elemento por defecto (TECHNICAL STUDIES)
    if (listItems.length > 0) {
        listItems[0].classList.add('active');
        const firstContent = listItems[0].querySelector('.cwts-div2');
        if (firstContent) {
            firstContent.style.display = 'block';
        }
    }
    
    // Agregar evento click a cada li
    listItems.forEach(function(item) {
        item.addEventListener('click', function() {
            // Cerrar todos los elementos
            listItems.forEach(function(li) {
                li.classList.remove('active');
                const content = li.querySelector('.cwts-div2');
                if (content) {
                    content.style.display = 'none';
                }
            });
            
            // Abrir el elemento clickeado
            this.classList.add('active');
            const content = this.querySelector('.cwts-div2');
            if (content) {
                content.style.display = 'block';
            }
        });
    });
});