    <?php
// Obtener la página actual
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Definir las categorías


$categories = [
    
    
    'sanitary' => [
        'name' => 'Sanitary / Storm drain',
        'image' => 'img/categories/sanitary.png',
        'file' => 'sanitary.php'
    ],
    
    
    'electrical' => [
    'name' => 'Electrical Manholes & Handholes',
    'image' => 'img/categories/electrical.png',
    'file' => 'electrical.php'
    ],
    
    'parking' => [
    'name' => 'Parking Stops',
    'image' => 'img/categories/parking.png',
    'file' => 'parking.php'
    ],

    'renewable' => [
        'name' => 'Renewable energy',
        'image' => 'img/categories/eolica.png',
        'file' => 'renewable.php'
    ],

    
    'spun' => [
    'name' => 'Spun Concrete pole',
    'image' => 'img/categories/spun.png',
    'file' => 'spun.php'
    ],
    
    
    'counterweights' => [
    'name' => 'Counterweights',
    'image' => 'img/categories/contrapeso.png',
    'file' => 'counterweights.php'
    ],

  
];

// Reorganizar: poner la categoría actual primero
$reordered_categories = [];
if (isset($categories[$current_page])) {
    $reordered_categories[$current_page] = $categories[$current_page];
    unset($categories[$current_page]);
}
$reordered_categories = array_merge($reordered_categories, $categories);
?>

<div class="list-products">
    <div class="row">
        <?php foreach ($reordered_categories as $key => $category): ?>
            <div class="col-md-4 mb-3">
                <div class="lp-div <?php echo ($current_page == $key) ? 'selected' : ''; ?>">
                    <a href="<?php echo $category['file']; ?>">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <img src="<?php echo $category['image']; ?>" alt="" class="lp-img">
                            </div>
                            <div class="col-6" id="lp-col">
                                <p class="lp-p"><?php echo $category['name']; ?></p>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>