<?php include_once dirname(__DIR__) . '/php/traduction.php'; ?>
<!DOCTYPE html>
<html lang="<?php echo $currentLang; ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>M2M - Move to México</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="shortcut icon" href="img/logo.png" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3.9.0/notyf.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
</head>

<body>
    <header>
        <nav class="navbar">
            <div class="nav-div">
                <a href="index.php" class="img-a"><img src="img/logo2.png" alt="M2M" class="nav-img"></a>
                <ul class="nav-ul">
                    <li><a href="index.php#nosotros"><?php echo translate('nav.nosotros'); ?></a></li>
                    <li><a href="index.php#servicios"><?php echo translate('nav.servicios'); ?></a></li>
                    <li><a href="https://blackbook.site" target="_blank" rel="noopener">BlackBook</a></li>
                </ul>
            </div>
            <div class="nav-div2">
                <a href="proyectos.php" class="nav-a"><?php echo translate('nav.proyectos'); ?> <i class="fa-solid fa-arrow-right"></i></a>
                <a href="simulador.php" class="nav-a"><?php echo translate('nav.simulador'); ?> <i class="fa-solid fa-arrow-right"></i></a>
                <a href="reclutamiento.php" class="nav-a"><?php echo translate('nav.reclutamiento'); ?> <i class="fa-solid fa-arrow-right"></i></a>
                <a href="contacto.php" class="nav-a ca"><?php echo translate('nav.contactanos'); ?> <i class="fa-solid fa-arrow-right"></i></a>
                <div class="nav-div3">
                    <a href="<?php echo getLanguageUrl('en'); ?>"><img src="img/iconos/eng.png" alt="English"></a>
                    <a href="<?php echo getLanguageUrl('es'); ?>"><img src="img/iconos/esp.png" alt="Español"></a>
                </div>
            </div>
        </nav>
    </header>

    <!-- Botón volver arriba -->
    <button id="btn-nav-top" class="btn-nav-top" title="<?php echo translate('common.back_to_top'); ?>" type="button">
        <i class="fa-solid fa-angle-up"></i>
    </button>

    <!-- Overlay contacto -->
    <div id="contacto-overlay" style="display:none;">
        <div class="contacto-content">
            <button id="close-contacto" type="button" class="nav-a ca"><i class="fa-solid fa-arrow-left"></i> <?php echo translate('common.inicio'); ?></button>
            <div class="nav-div3">
                <a href="<?php echo getLanguageUrl('en'); ?>"><img src="img/iconos/eng.png" alt="English"></a>
                <a href="<?php echo getLanguageUrl('es'); ?>"><img src="img/iconos/esp.png" alt="Español"></a>
            </div>
        </div>
        <div class="contacto-div">
            <img src="img/contactanos.jpg" alt="Contacto" class="contacto-img">
            <p class="contacto-p"><?php echo translate('contact.quote'); ?>
            </p>
        </div>
        <div class="contacto-div2">
            <p class="contacto-p2"><?php echo translate('contact.title'); ?></p>
            <img src="img/lineaVerde.png" alt="" class="contacto-img2">
            <div class="contacto-div3">
                <div class="contacto-div4">
                    <i class="fa-solid fa-envelope"></i>
                    <div>
                        <p class="contacto-p3"><?php echo translate('contact.email_us'); ?></p>
                        <a href="mailto:contact@m2m.com.mx" class="contacto-a">contact@m2m.com.mx</a>
                    </div>
                </div>
                <div class="contacto-div4">
                    <i class="fa-solid fa-phone"></i>
                    <div>
                        <p class="contacto-p3"><?php echo translate('contact.call_us'); ?></p>
                        <a href="tel:+4424451768" class="contacto-a">442 445 1768</a>
                    </div>
                </div>
            </div>

            <div class="contacto-div5">
                <p class="contacto-p3"><?php echo translate('contact.form_title'); ?></p>
                <form id="contactForm" class="contactForm" novalidate>
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <label for="name"><?php echo translate('contact.name'); ?></label>
                                <input type="text" id="name" name="name" required class="form-control">
                            </div>
                            <div class="col-6">
                                <label for="phone"><?php echo translate('contact.phone'); ?></label>
                                <input type="tel" id="phone" name="phone" required class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <label for="email"><?php echo translate('contact.email'); ?></label>
                                <input type="email" id="email" name="email" required class="form-control">
                            </div>
                            <div class="col-6">
                                <button type="submit" class="btn btn-send"><?php echo translate('contact.send'); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>

        <div class="contacto-redes">
            <p class="contacto-p4"><?php echo translate('contact.social_networks'); ?></p>
            <div class="contacto-redes2">
                <a href="https://www.instagram.com/m2m_movetomexico/" target="_blank" rel="noopener"><i class="fa-brands fa-instagram"></i></a>
                <a href="https://www.facebook.com/m2m.movetomexico" target="_blank" rel="noopener"><i class="fa-brands fa-facebook-f"></i></a>
                <a href="https://x.com/M2MMoveToMexico" target="_blank" rel="noopener"><i class="fa-brands fa-x-twitter"></i></a>
                <a href="https://www.tiktok.com/@m2m_movetomexico" target="_blank" rel="noopener"><i class="fa-brands fa-tiktok"></i></a>
                <a href="https://www.linkedin.com/company/m2m-move-to-mexico" target="_blank" rel="noopener"><i class="fa-brands fa-linkedin-in"></i></a>
                <a href="https://wa.me/524424451768" target="_blank" rel="noopener"><i class="fa-brands fa-whatsapp"></i></a>
            </div>
        </div>
    </div>

    <!-- Sidebar móvil -->
    <div id="sidebar" class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <img src="img/logo2.png" alt="Logo">
            </div>
            <button id="close-sidebar" type="button" class="sidebar-close" aria-label="Cerrar menú">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>

        <ul class="sidebar-menu">
            <li><a href="index.php#nosotros"><?php echo translate('nav.nosotros'); ?></a></li>
            <li><a href="index.php#servicios"><?php echo translate('nav.servicios'); ?></a></li>
            <li><a href="proyectos.php"><?php echo translate('nav.proyectos'); ?></a></li>
            <li><a href="simulador.php"><?php echo translate('nav.simulador'); ?></a></li>
            <li><a href="reclutamiento.php"><?php echo translate('nav.reclutamiento'); ?></a></li>
            <li><a href="contacto.php" class="cta"><?php echo translate('nav.contactanos'); ?></a></li>
            <li><a href="https://blackbook.site" target="_blank" rel="noopener">BlackBook</a></li>
        </ul>

        <hr class="sidebar-sep" />

        <div class="sidebar-languages">
            <a href="<?php echo getLanguageUrl('en'); ?>"><img src="img/iconos/eng.png" alt="EN"></a>
            <a href="<?php echo getLanguageUrl('es'); ?>"><img src="img/iconos/esp.png" alt="ES"></a>
        </div>
    </div>

    <button id="open-sidebar" type="button" class="sidebar-open" aria-label="Abrir menú">
        <i class="fa-solid fa-bars"></i>
    </button>
    <div id="sidebar-overlay" class="sidebar-overlay"></div>