<?php
return [
    'nav' => [
        'nosotros' => 'Nosotros',
        'servicios' => 'Servicios',
        'proyectos' => 'Proyectos',
        'simulador' => 'Simulador',
        'reclutamiento' => 'Reclutamiento',
        'contactanos' => 'Contáctanos',
    ],
    'home' => [
        'carousel' => [
            'slide1' => [
                'title' => 'Servicios de Ingeniería 
                y Project Management',
                'description' => 'Nuestros consultores aportan décadas de experiencia 
                trabajando en todo México, Estados Unidos y Latinoamérica.',
            ],
            'slide2' => [
                'title' => 'Somos una red de recursos 
                humanos profesionales en 
                todo México.',
                'description' => 'Nuestros experimentados ejecutivos han contribuido al 
                establecimiento de 78 empresas multinacionales en México.',
            ],
            'slide3' => [
                'title' => 'Metodología comprobada 
                para proyectos industriales 
                de clase mundial',
                'description' => 'Nuestra metodología asegura que cada fase del proyecto, 
                cumpla con los más altos estándares internacionales, 
                generando parques industriales que superan expectativas y 
                ofrecen retornos sostenibles.',
            ],
        ],
        'about' => [
            'title' => 'NOSOTROS',
            'subtitle' => 'No solo gestionamos 
            proyectos, guiamos a 
            empresas en cada paso 
            de su expansión en México.',
            'description' => 'Nuestros consultores aportan décadas de experiencia 
            trabajando en todo México, Estados Unidos y Latinoamérica.',
            'description2' => 'A lo largo de este tiempo los experimentados ejecutivos han 
            contribuido al establecimiento de 78 empresas multinacionales en 
            México.',
            'stats' => [
                'companies' => '+78',
                'companies_text' => 'Empresas Multinacionales',
                'experience' => 'Décadas de experiencia',
            ],
        ],
        'different' => [
            'title' => 'Qué nos hace diferentes',
            'connection_title' => 'Nuestra capacidad para conectar con los clientes',
            'connection_description' => 'A lo largo de este tiempo los experimentados ejecutivos han contribuido al establecimiento de 78 empresas multinacionales en México.',
            'solutions_title' => 'Orientación a las soluciones',
            'solutions_description' => 'Nos centramos en qué más podamos hacer para lograr el éxito para usted.',
            'services_description' => 'Ofrecemos servicios de gestión de proyectos a través de un equipo local en México.',
            'methodology_description' => 'Nuestros gerentes de proyecto, respaldados por la metodología M2M, garantizan altos estándares de ética, servicio, profesionalismo, transparencia y mejora continua, aportando valor agregado y ahorros significativos en cada construcción.',
        ],
        'experience' => [
            'title' => 'Más de 28 años',
            'description' => 'Trabajando para las más grandes Empresas de 
            Desarrollo Industrial en México, el conocimiento 
            industrial y comercial está a su servicio.',
        ],
        'services' => [
            'title' => 'NUESTROS SERVICIOS',
            'subtitle' => 'Soluciones para tu proyecto',
            'description' => 'Ofrecemos una amplia gama de servicios especializados para acompañarte en cada etapa de tu proyecto industrial.',
            'what_we_can_do' => 'Qué podemos hacer por ti',
            'engineering' => [
                'title' => 'Ingeniería',
                'description' => 'Diseñamos soluciones técnicas precisas y eficientes para cada 
                etapa de tu proyecto.',
            ],
            'project_management' => [
                'title' => 'Construction Project Management',
                'description' => 'Planificamos, coordinamos y ejecutamos con excelencia para 
                garantizar resultados a tiempo y dentro del presupuesto.',
            ],
            'due_diligence' => [
                'title' => 'Due diligence (site selection)',
            ],
            'cost_management' => [
                'title' => 'Gestión de costos',
            ],
            'engineering_planning' => [
                'title' => 'Diseño y planificación de ingeniería',
            ],
            'construction_permits' => [
                'title' => 'Proceso de permisos de construcción',
            ],
            'procurement_bidding' => [
                'title' => 'Adquisiciones proceso de licitación',
            ],
            'construction_control' => [
                'title' => 'Acuerdo de control de construcción',
            ],
            'construction_guidelines' => [
                'title' => 'Directrices de construcción',
            ],
            'health_safety' => [
                'title' => 'Directrices de salud y seguridad',
            ],
            'project_closure' => [
                'title' => 'Cierre del proyecto',
            ],
        ],
        'recruitment' => [
            'title' => '¡Únete a nuestro equipo!',
            'subtitle' => 'Estamos buscando talento como el tuyo.',
            'description' => 'Tu próximo reto profesional comienza aquí. 
            ¡Descubre nuestras vacantes!',
            'apply_now' => '¡Postulate ahora!',
        ],
        'blackbook' => [
            'title' => 'BLACKBOOK',
            'subtitle' => 'Conoce BlackBook, nuestra plataforma de aprendizaje',
            'description1' => 'Creamos Construction Project Managers altamente especializado con conocimientos multidisciplinarios, que ejecutan con alta dirección y liderazgo, macro proyectos de construcción.',
            'description2' => 'La metodología de Project Management de BlackBook reúne más de 1,500 temas que analizan, controlan, miden y revisan todo el ciclo de vida de un proyecto. Incluye herramientas de capacitación para ingenieros y arquitectos que buscan certificarse como Project Managers.',
            'visit_site' => 'Visitar sitio',
        ],
        'playbooks' => [
            'title' => '+24 Playbooks',
            'description1' => 'La profesión de Project Manager exige amplios conocimientos técnicos y la capacidad de coordinar múltiples procesos y especialidades de forma simultánea.',
            'description2' => 'Implica diferenciar las propiedades del proyecto, definir el procedimiento constructivo correcto y liderar en un entorno interdisciplinario, desde la planeación hasta el cierre total de la obra.',
            'intro_pm' => 'Introducción al Project Management',
            'strategic_leadership' => 'Liderazgo estratégico',
            'quality_management' => 'Gestión de calidad',
            'safety_hygiene' => 'Seguridad e Higiene',
            'procurement' => 'Adquisiciones',
            'land_development' => 'Desarrollo de Terrenos',
            'strategic_planning' => 'Planeación estratégica',
            'construction_permits' => 'Permisos de construcción',
            'construction_contract' => 'Contrato de construcción',
            'closing_stage' => 'Etapa de cierre',
            'project_design' => 'Diseño del proyecto',
            'data_center' => 'Centro de Datos',
            'cost_management' => 'Gestión de Costos',
            'control_monitoring' => 'Control y monitoreo',
            'site_selection_process' => 'Proceso de Selección de Sitio',
            'clean_rooms' => 'Cuartos Limpios',
            'investment_funds' => 'Fondos de Inversión',
            'new_cities' => 'Nuevas Ciudades',
            'speculative' => 'Especulativos',
            'commissioning' => 'Comisionamiento',
            'case_study' => 'Caso de Estudio',
            'risk_management' => 'Gestión de Riesgos',
        ],
        'recent_projects' => [
            'title' => 'Proyectos recientes',
            'description' => 'Cada proyecto es una oportunidad para demostrar nuestra 
            experiencia y compromiso.',
            'view_projects' => 'Ver proyectos',
        ],
    ],
    'projects' => [
        'hero' => [
            'title' => 'Proyectos recientes',
            'description' => 'Cada proyecto es una oportunidad para demostrar nuestra 
            experiencia y compromiso.',
            'description2' => 'Desde complejas obras industriales hasta desarrollos a gran 
            escala, entregamos resultados que cumplen y superan 
            las expectativas de nuestros clientes.',
        ],
        'horizon' => [
            'title' => 'Horizon Industrial Park',
            'description' => 'El primer edificio especulativo contara con 11,832 m² de area techada, perfecto para 
            almacenamiento, manufactura ligera, e-commerce y mas. Estratégicamente ubicado 
            con fácil accesos a carreteras y vías férreas.',
            'area_label' => 'Área:',
            'area_value' => '32 Hectáreas en Fase 1',
            'services_label' => 'Servicios prestados:',
            'project_management' => 'Project management',
            'bim' => 'BIM',
        ],
        'cisef' => [
            'title' => 'CISEF Industrial Park',
            'description' => 'CISEF Industrial Park esta estratégicamente ubicado en Gómez Palacio, Durango, 
            México dentro de una zona libre de comercio diseñada para impulsar sus operaciones de 
            comercio exterior.',
            'area_label' => 'Área:',
            'area_value' => '141 Hectáreas',
            'services_label' => 'Servicios prestados:',
            'project_management' => 'Project management',
            'bim' => 'BIM',
        ],
    ],
    'simulator' => [
        'hero' => [
            'title' => 'Simulador de costos',
            'subtitle' => 'Potencie sus proyectos con precisión.',
        ],
        'main' => [
            'title' => 'Simulador de costos',
            'description1' => 'Descubre una forma mas inteligente de planificar las finanzas de su proyecto con nuestro innovador Simulador de costos.',
            'description2' => 'Diseñada para proporcionar estimaciones precisas, esta herramienta le permite explorar multiples escenarios de costes de construcción y crear presupuestos preliminares para mejoras de capital, ampliaciones y nuevas construcciones.',
            'description3' => 'Tenga en cuenta que los costes generados por el simulador son estimaciones y pueden variar en función de los cambios en el alcance del proyecto, las condiciones del mercado y otras variables. Con esta herramienta, obtendrá información valiosa para tomar decisiones informadas, optimizar su presupuesto y convertir su visión en realidad con confianza.',
            'form_intro' => 'Introduzca los requerimientos para el presupuesto estimado de su proyecto',
            'step_indicator' => 'Step 1 of 4',
        ],
        'form' => [
            'step1' => [
                'title' => '1. Dimensiones del proyecto',
                'storage_space' => 'Espacio de almacenamiento',
                'storage_space_tooltip' => 'Área destinada para el almacenamiento de productos o materiales en metros cuadrados',
                'production_space' => 'Espacio de producción',
                'production_space_tooltip' => 'Área destinada para actividades de manufactura o producción en metros cuadrados',
                'mezanine_area' => 'Área de mezzanine',
                'mezanine_tooltip' => 'Piso intermedio entre dos plantas principales de un edificio que maximiza el espacio disponible',
                'warehouse_area' => 'Área del almacén',
                'warehouse_tooltip' => 'Superficie total ocupada por la estructura del almacén en metros cuadrados',
                'office_space' => 'Oficinas',
                'office_tooltip' => 'Espacio destinado para oficinas administrativas y de gestión en metros cuadrados',
                'outside_terrain' => 'Área exterior / patios',
                'outside_tooltip' => 'Espacios exteriores como patios, áreas de maniobra y estacionamientos en metros cuadrados',
                'total_site' => 'Superficie total de la planta',
                'total_site_tooltip' => 'Área total del terreno que ocupará el proyecto, incluyendo construcciones y exteriores',
                'land_price' => 'Precio de compra del terreno',
                'land_price_tooltip' => 'Costo estimado de adquisición del terreno en pesos mexicanos por metro cuadrado',
            ],
            'step2' => [
                'title' => '2. Características del almacén',
                'clear_height' => 'Altura libre de almacenamiento',
                'clear_height_tooltip' => 'Altura disponible desde el suelo hasta el techo para almacenamiento en metros',
                'loading_docks' => 'Número de muelles de carga',
                'loading_docks_tooltip' => 'Cantidad de muelles o plataformas de carga para camiones',
                'loading_doors' => 'Número de puertas de carga',
                'loading_doors_tooltip' => 'Cantidad de puertas para carga y descarga de mercancías',
                'floor_capacity' => 'Capacidad de carga máxima del suelo',
                'floor_capacity_tooltip' => 'Peso máximo que puede soportar el suelo por metro cuadrado en toneladas',
                'mezanine_capacity' => 'Capacidad máxima del mezzanine',
                'mezanine_capacity_tooltip' => 'Peso máximo que puede soportar el mezzanine por metro cuadrado en toneladas',
                'foundation_required' => 'Se requiere cimentación',
                'foundation_tooltip' => 'Marque esta casilla si su proyecto requiere la construcción de nueva cimentación',
                'fire_walls' => 'Paredes y puertas cortafuegos',
                'fire_walls_tooltip' => 'Elementos de seguridad contra incendios para contener el fuego',
            ],
            'step3' => [
                'title' => '3. Servicios',
                'climate_control' => 'Climatización',
                'climate_tooltip' => 'Sistema de control de temperatura y ventilación para el edificio',
                'security_gate' => 'Puerta de seguridad',
                'security_gate_tooltip' => 'Sistema de acceso controlado para la entrada principal del complejo',
                'fire_protection' => 'Protección contra incendios - rociadores',
                'fire_protection_tooltip' => 'Sistema de rociadores automáticos para protección contra incendios',
                'security_fence' => 'Valla de seguridad',
                'security_fence_tooltip' => 'Cercado perimetral para protección y delimitación del área del proyecto',
                'burglar_alarm' => 'Alarma antirrobo',
                'burglar_alarm_tooltip' => 'Sistema de detección y alarma para prevenir intrusiones',
                'office_setting' => 'Entorno de oficina',
                'office_setting_tooltip' => 'Nivel de equipamiento y acabados para las áreas de oficina',
            ],
            'step4' => [
                'ready_title' => '¡Tu presupuesto paramétrico está listo!',
                'share_data' => 'Compártenos tus datos para enviártelo por correo.',
                'privacy_note' => 'Toda tu información está protegida bajo nuestra política de privacidad y confidencialidad.',
                'title' => '4. Información de Contacto',
                'full_name' => 'Nombre Completo',
                'full_name_tooltip' => 'Ingrese su nombre completo tal como aparece en documentos oficiales',
                'email' => 'Email',
                'email_tooltip' => 'Dirección de correo electrónico válida donde recibirá la cotización',
                'phone' => 'Teléfono',
                'phone_tooltip' => 'Número de teléfono para contacto directo sobre el proyecto',
                'company' => 'Empresa',
                'company_tooltip' => 'Nombre de la empresa u organización para la cual se realizará el proyecto',
                'linkedin' => 'LinkedIn (opcional)',
                'linkedin_tooltip' => 'Su perfil de LinkedIn para establecer conexiones profesionales',
                'country' => 'País',
                'country_tooltip' => 'País donde se desarrollará el proyecto de construcción',
                'location' => 'Ubicación',
                'location_tooltip' => 'Ciudad o región específica donde se ubicará el proyecto',
            ],
            'buttons' => [
                'next' => 'Siguiente',
                'submit' => 'Enviar Mi Cotización',
            ],
            'validation' => [
                'storage_space' => 'Por favor, introduzca el espacio de almacenamiento.',
                'production_space' => 'Por favor, introduzca el espacio de producción.',
                'mezanine' => 'Por favor, introduzca el área de mezzanine.',
                'warehouse' => 'Por favor, introduzca el área del almacén.',
                'office' => 'Por favor introduzca el espacio de la oficina.',
                'outside' => 'Por favor, introduzca el área exterior.',
                'total_site' => 'Por favor, introduzca la superficie total de la planta.',
                'land_price' => 'Introduzca el precio de compra del terreno.',
                'clear_height' => 'Por favor, introduzca la zona de almacenamiento de altura libre.',
                'loading_docks' => 'Por favor, introduzca el número de muelles de carga.',
                'loading_doors' => 'Introduzca el número de puertas de carga.',
                'floor_capacity' => 'Introduzca la capacidad de carga máxima del suelo.',
                'mezanine_capacity' => 'Por favor, introduzca la capacidad de carga máxima del mezzanine área.',
                'climate_control' => 'Por favor, seleccione la opción de climatización.',
                'security_gate' => 'Por favor, introduzca la puerta de seguridad.',
                'fire_protection' => 'Por favor, seleccione la opción de protección contra incendios.',
                'security_fence' => 'Por favor, introduzca la valla de seguridad.',
                'burglar_alarm' => 'Por favor, introduzca la alarma antirrobo.',
                'office_setting' => 'Por favor, seleccione el entorno de oficina.',
                'name' => 'Por favor, introduzca su nombre.',
                'email_valid' => 'Introduzca una dirección de correo electrónico válida.',
                'phone' => 'Por favor, introduzca su número de teléfono.',
                'company' => 'Introduzca el nombre de su empresa.',
                'country' => 'Por favor, introduzca su país.',
                'location' => 'Por favor, introduzca su ubicación.',
            ],
            'options' => [
                'select' => 'Seleccionar',
                'hvac' => 'HVAC',
                'swamp_coolers' => 'Enfriadores SWAMP',
                'no_ac' => 'Sin aire acondicionado',
                'nfpa' => 'NFPA',
                'fm' => 'FM',
                'basic' => 'Básica',
                'equipped' => 'Equipada',
                'premium' => 'Premium',
            ],
            'placeholders' => [
                'storage_space' => '500 - 1000',
                'production_space' => '300 - 600',
                'mezanine' => '150 - 300',
                'warehouse' => '1000 - 2000',
                'office' => '100 - 200',
                'outside' => '200 - 500',
                'total_site' => '1200 - 2500',
                'land_price' => '50-150',
                'clear_height' => '11 - 12',
                'loading_docks' => '4',
                'loading_doors' => '8 - 24 puertas',
                'floor_capacity' => '5',
                'mezanine_capacity' => '250 - 500',
                'security_gate' => 'Portón deslizante automatizado',
                'security_fence' => 'Valla perimetral de 3 metros',
                'burglar_alarm' => 'Alarma con sensores de movimiento',
                'name' => 'ej.: Ricardo Pérez',
                'email' => 'ej.: ricardo.perez@example.com',
                'phone' => 'ej.: 5551234567',
                'company' => 'ej.: Acme S.A. de C.V.',
                'linkedin' => 'ej.: ricardo-perez',
                'country' => 'ej.: México',
                'location' => 'ej.: Ciudad de México',
            ],
        ],
    ],
    'recruitment' => [
        'hero' => [
            'title' => 'Únete a nuestro equipo',
            'subtitle' => 'Estamos buscando talento como el tuyo.',
            'description' => 'Tu próximo reto profesional comienza aquí. ¡Descubre nuestras vacantes!',
        ],
        'jobs' => [
            'section_title' => 'RECLUTAMIENTO',
            'title' => 'Oportunidades de trabajo',
            'description' => 'En M2M no solo gestionamos proyectos - creamos oportunidades para crecer, innovar y generar impacto. Explora nuestras vacantes actuales o enviar tu CV a:',
            'looking_for' => 'Buscamos especialistas en:',
            'specialties' => [
                'project_management' => 'Gestión de Proyectos',
                'project_scheduling' => 'Programación de Proyectos',
                'bim' => 'BIM',
                'architecture' => 'Arquitectura',
                'structural_engineering' => 'Ingeniería Estructural',
                'civil_engineering' => 'Ingeniería Civil',
                'technical_drawing' => 'Dibujo Técnico',
                'electrical_engineering' => 'Ingeniería Eléctrica',
                'document_control' => 'Control Documental',
                'hvac_systems' => 'Sistemas HVAC',
                'instrumentation' => 'Instrumentación',
                'process_engineering' => 'Ingeniería de Procesos',
                'fire_protection' => 'Protección Contra Incendios',
                'telecommunications' => 'Telecomunicaciones',
                'cost_integration' => 'Integración de Costos',
            ],
        ],
        'internships' => [
            'section_title' => 'RECLUTAMIENTO',
            'title' => 'Prácticas profesionales',
            'question' => '¿Eres estudiante o recién egresado y quieres comenzar tu carrera en un ambiente dinámico y retador?',
            'offer' => 'En M2M te ofrecemos la oportunidad de integrarte a proyectos reales, aprender de expertos y desarrollar tus habilidades en ingeniería y gestión de proyectos.',
            'call_to_action' => 'Únete a nuestro equipo y construye el futuro con nosotros. Envía tu CV a:',
        ],
    ],
    'services' => [
        'common' => [
            'service_label' => 'SERVICIO',
        ],
        'construction_agreement' => [
            'title' => 'Acuerdo de control de construcción',
            'section_title' => 'Contratos de construcción',
            'description1' => 'Para proteger los intereses de nuestros clientes, el equipo de M2M tiene un procedimiento establecido en el que describimos de forma sencilla los documentos que recomendamos habitualmente, incluidos como parte de este procedimiento crítico.',
            'description2' => 'Es esencial asegurarse de que los Contratistas Generales y sus subcontratistas implicados en la licitación comprenden y cumplen los requisitos legales que deben considerarse en el marco jurídico del proyecto, como el pago por adelantado, las fianzas de cumplimiento, las fianzas por vicios ocultos, el seguro de responsabilidad civil y la retención del fondo de garantía.',
            'process_intro' => 'En esta fase, M2M habrá proporcionado detalles exhaustivos para permitir a nuestros clientes hacer recomendaciones imparciales a nuestros clientes. Llevaremos a cabo lo siguiente:',
            'services' => [
                'letter_of_intent' => 'Ayudar con la Carta de Intenciones para la Coordinación de los Contratistas Generales seleccionados.',
                'contractor_coordination' => 'Coordinación de Contratistas.',
                'legal_agreement' => 'Asistencia y coordinación del Acuerdo Legal de Construcción.',
                'contract_consolidation' => 'Consolidación de los documentos del contrato.',
                'performance_bond' => 'Coordinación de la Fianza de Cumplimiento.',
                'liability_insurance' => 'Coordinación del Seguro de Responsabilidad Civil.',
                'submission_control' => 'Control del proceso de autorización de presentación.',
                'payment_request' => 'Solicitud de pago y calendario de gastos de pago.',
            ],
        ],
        'project_closure' => [
            'title' => 'Cierre de proyecto',
            'section_title' => 'Finalización del proyecto',
            'description' => 'La Metodología de Consultoría de Cierre de Proyecto de M2M define el resultado excelente de la inversión del proyecto; un buen Cierre de Proyecto asegura la rentabilidad de nuestros clientes y los más altos estándares de calidad para asegurar la consecución de los objetivos, plazos, compromisos y contractuales del proyecto.',
            'process_description' => 'Tras un largo proceso constructivo, el Project Manager de M2M se asegura de que el Contratista General cumple con la resolución de los detalles constructivos y la entrega formal de toda la información del proyecto.',
            'closure_description' => 'El cierre financiero y administrativo se completará de forma ordenada siguiendo las directrices y normativas del contrato de construcción.',
        ],
        'construction_guidelines' => [
            'title' => 'Directrices generales de construcción',
            'section_title' => 'Garantía de Calidad',
            'description' => 'La Garantía de Calidad se centra en la prevención de defectos a diferencia del control de calidad que se centra en la detección de defectos una vez que el artículo está terminado o construido, los métodos de gestión de la construcción o producción se concentran en garantizar que la calidad se integra en el mismo sistema de producción se describe a continuación:',
            'points' => [
                'evolution' => 'Evolución de la garantía de calidad a partir del control de calidad',
                'standards' => 'Normas de aseguramiento de la calidad',
                'development' => 'Desarrollo e implantación de un sistema de garantía de calidad',
            ],
        ],
        'due_diligence' => [
            'title' => 'Debida diligencia (selección de sitio)',
            'section_title' => 'Diligencia debida Proceso de selección del emplazamiento',
            'description1' => 'Ayudar en cualquier evaluación de la propiedad sitio de diligencia debida, coordinar y llevar a cabo conversaciones con los organismos gubernamentales, los desarrolladores industriales para comprender y confirmar el uso requerido del suelo proceso de zonificación para el municipio específico, ayudar al cliente en la información a las partes interesadas sobre el proyecto, según lo solicitado.',
            'description2' => 'Ayudar al cliente a obtener las autorizaciones de varianza de zonificación, uso del suelo y/u otras autorizaciones de planes necesarias mediante la supervisión y coordinación del equipo del proyecto en la preparación y presentación de solicitudes y presentaciones a los residentes de la zona y a las juntas municipales.',
            'cost_advice' => 'Asesorar sobre los costes potenciales relacionados con las consideraciones y selección del emplazamiento, incluida la topografía existente, la disponibilidad de servicios públicos y/o su reubicación, las condiciones del suelo y los requisitos de aparcamiento',
            'services' => [
                'economic_analysis' => 'Asistir al cliente en la realización y/o revisión del análisis económico del/de los proyecto(s), incluyendo coste básico, arrendamiento, financiación, enajenación, sin incluir hipótesis de impacto fiscal. Matriz comparativa de alternativas de coste del suelo.',
                'easements' => 'Asistencia en la identificación e incorporación de las servidumbres y cláusulas necesarias.',
                'risk_management' => 'Asistencia en la supervisión de la prevención de pérdidas y la gestión de riesgos.',
                'permits_process' => 'Asistencia en el proceso de obtención de permisos/recomendaciones de agilización.',
                'environmental_impact' => 'Asistencia en la fase uno, impacto medioambiental, estudio de remediación, conformidad medioambiental para la construcción (MIA) y proceso de solicitud.',
                'electrical_feasibility' => 'Asistencia en la evaluación de viabilidad eléctrica con derechos de propiedad de CFE y KVA por parte de expedidores terceros.',
                'hydrological_studies' => 'Ayudar con el estudio de análisis hidrológico, pruebas de suelo de condiciones geológicas, encuesta, registro de parcela, mapa topográfico y control dimensional, por consultores de 3rtd party y preparación del sitio.',
                'utilities_infrastructure' => 'Organizar la investigación de la infraestructura de servicios públicos del emplazamiento por parte de otros según sea necesario para apoyar el proyecto, ayudar en las conexiones de agua doméstica, alcantarillado, gas natural, fibra óptica, sistema de protección contra incendios.',
                'schedule_control' => 'Asistencia y control del calendario del proyecto.',
            ],
        ],
        'cost_management' => [
            'title' => 'Gestión de costos',
            'section_title' => 'Liberación de valor a lo largo de todo el proyecto',
            'description1' => 'Nuestros aparejadores se dedican a mantener el control financiero y a desbloquear el valor mediante la validación del proceso, el proceso de aprobación de la financiación, la contabilidad adecuada. la documentación detallada y los informes financieros.',
            'description2' => 'Disponemos de las herramientas necesarias para desarrollar y simular diferentes alternativas de costes de construcción y generar presupuestos preliminares para determinar los costes de construcción, las mejoras de capital de TI y las ampliaciones, defendiendo la inversion aproximada necesaria para los proyectos de nuestros clientes.',
            'description3' => 'Contamos con las herramientas para desarrollar Simulación de Alternativas de Construcción de diferentes constes y generar Presupuestos Preliminares para determinar los Costes de Construcción, TI\'s mejoras de capital y ampliaciones, definiendo la cantidad aproximada de inversión requerida para los proyectos de nuestros clientes.',
            'benefits1' => 'Los resultados clave incluyen una definición precisa del presupuesto para generar un plan financiero de costes de construcción adecuado, definiendo la cantidad correcta de dinero que se necesita invertir en sus proyectos para generar un alto nivel de satisfacción del cliente',
            'benefits2' => 'La gestion de costes genera importantes ahorros durante la generación del proceso de licitación de la construcción con los contratistas generales, lo que supone una gran ventaja para nuestros clientes.',
        ],
        'engineering' => [
            'title' => 'Ingeniería',
            'hero_subtitle' => 'Diseñamos soluciones técnicas precisas y eficientes para cada etapa de tu proyecto.',
            'section_title' => 'Servicios de ingeniería',
            'description' => 'Desarrollamos ingeniería conceptual, básica y de detalle para core & shell y sistemas críticos y de soporte en cualquier tipo de instalación industrial.',
            'services' => [
                'conceptual' => 'Ingeniería conceptual',
                'technical_representation' => 'Representación Técnica y Asistencia',
                'bim_integration' => 'Integración de Modelo BIM',
                'third_party_design' => 'Revisión de diseño de terceros',
            ],
            'delivery_phases' => 'Nuestras fases de entrega incluyen:',
            'phases' => [
                'preconstruction' => 'Pre-construcción',
                'engineering' => 'Ingeniería',
                'procurement' => 'Adquisiciones',
                'construction' => 'Construcción',
                'maintenance' => 'Mantenimiento',
            ],
        ],
        'construction_permits_page' => [
            'title' => 'Permisos de construcción',
            'section_title' => 'Tramitación de permisos de construcción',
            'help_text' => 'Le ayudamos a simplificar el proceso de obtención de permisos',
            'description' => 'Obtener Permisos de Construcción en México es una actividad burocrática que toma tiempo y puede ser costosa. Nuestros Gerentes de Proyecto obtendrán los permisos dentro de una ejecución oportuna, siguiendo las políticas de cumplimiento de Ética Global, códigos rigurosos y estándares de ética que deben seguirse. A través de M2M\'s, transferimos la responsabilidad a los Contratistas Generales asignados al proyecto y a los expedidores profesionales para que se realice correctamente para asegurar la obtención de la factibilidad con las autoridades Locales, Estatales y Federales y los proveedores de servicios públicos.',
        ],
        'more_services' => [
            'title' => 'Más servicios',
            'services_list' => [
                'due_diligence' => 'Due diligence (site selection)',
                'cost_management' => 'Gestión de costos',
                'engineering_planning' => 'Diseño y planificación de ingeniería',
                'construction_permits' => 'Proceso de permisos de construcción',
                'bidding_process' => 'Adquisiciones proceso de licitación',
                'construction_agreement' => 'Acuerdo de control de construcción',
                'construction_guidelines' => 'Directrices de construcción',
                'health_safety' => 'Directrices de salud y seguridad',
                'project_closure' => 'Cierre del proyecto',
            ],
        ],
        'engineering_planning' => [
            'title' => 'Planificación de ingeniería',
            'section_title' => 'Diseño técnico & Planificación estratégica',
            'description1' => 'Un plan de proyecto detallado no es más que una lista de las tareas y actividades que deben realizarse para alcanzar un hito o producir un entregable.',
            'description2' => 'Mientras que la carta del proyecto se crea a nivel macro, los planes detallados del proyecto están a nivel micro y funcionan como plan de trabajo para cada miembro del equipo.',
            'description3' => 'El Director de Proyecto trabaja con el equipo del proyecto para crear el diseño técnico y de ingeniería, la lista de tareas, el plan de recursos, el plan de comunicaciones, el presupuesto y el calendario inicial del proyecto, y establece las funciones y responsabilidades del equipo del proyecto y de las partes interesadas.',
        ],
        'bidding_process_page' => [
            'title' => 'Adquisición de procesos de licitación',
            'section_title' => 'Liberación de valor a lo largo de todo el proyecto',
            'subtitle' => 'Proceso de contratación y licitación - Le facilitamos la selección del contratista adecuado para su proyecto',
            'description' => 'La ubicación de sus instalaciones importa ahora más que nunca. M2M le ayudará a identificar a los mejores contratistas y subcontratistas aplicando un riguroso proceso de selección para determinar los mejores talentos. Consideramos igual de necesario comprender los valores y el enfoque del proveedor potencial para recomendarle un proveedor que se alinee con sus valores.',
            'selection_process_intro' => 'Nuestro detallado proceso de selección para cada proveedor incluye',
            'selection_items' => [
                'technical_evaluation' => 'Evaluar y verificar la capacidad técnica, la viabilidad comercial, la solidez y solvencia financiera y la calificación jurídica de un proveedor.',
                'facility_visits' => 'Organización de visitas a las instalaciones',
                'bidder_preselection' => 'Preselección de licitadores',
                'proposal_preparation' => 'Preparación, envío y respuesta a la solicitud de propuestas.',
            ],
            'process_benefits' => 'Nuestro proceso está diseñado para ser sencillo y ahorrarle tiempo y dinero seleccionando a un contratista que se ajuste a sus valores y tenga las credenciales necesarias para llevar a cabo el trabajo con un alto nivel de calidad.',
        ],
        'project_management_page' => [
            'title' => 'Construction Project Management',
            'hero_subtitle' => 'Dirigimos y supervisamos cada fase de la construcción.',
            'main_title' => 'En M2M gestionamos proyectos de construcción de principio a fin.',
            'description' => 'Coordinamos equipos, optimizamos recursos y supervisamos cada detalle para garantizar que tu obra cumpla con los mas altos estándares de calidad, se entregue en tiempo y se mantenga dentro del presupuesto.',
        ],
        'health_safety_page' => [
            'title' => 'Directrices de salud y seguridad',
            'section_title' => 'Mejorar la seguridad con directrices claras',
            'description1' => 'Mantener al día los procedimientos de seguridad y salud en el proceso de construcción es otra de las importantes tareas que los Project Managers de M2M realizan a diario en nombre de nuestros clientes.',
            'description2' => 'Siempre existen probabilidades de accidentes en la construcción, nuestro objetivo es evitarlos y exhortar a los contratistas a cumplir con las obligaciones que establece la ley en relación a las Leyes de Protección Civil y del Seguro Social, la Ley Federal del Trabajo y la Secretaría del Trabajo y Previsión Social.',
            'description3' => 'El playbook de Seguridad y Salud de M2M\'s way ha sido elaborado como parte de la experiencia en la construcción de un gran número de proyectos, servirá de guía durante el proceso constructivo, el H&S Project Manager revisará de manera metódica y rutinaria que los Contratistas realicen los cursos de seguridad diarios y las inspecciones de los protocolos de seguridad e higiene, cada trabajador deberá firmar las listas de asistencia y capacitación de estos cursos.',
        ],
    ],
    'modals' => [
        'content_title' => 'Contenido del playbook:',
        'index' => 'Índice',
        'subjects' => 'Temario:',
        'project_management' => [
            'title' => 'Introducción al Project Management',
            'description1' => 'El servicio especializado de Due Diligence y Selección de sitio está adquiriendo una relevancia creciente en los proyectos más importantes a nivel mundial.',
            'description2' => 'Un análisis exhaustivo de las características legales, ambientales, hidrológicas y geológicas, así como de los servicios locales e infraestructura, proporciona información crucial para la toma de decisiones informadas en las inversiones de nuestros clientes.',
            'content' => [
                'site_selection_guide' => 'Guía para la selección de sitio',
                'introduction' => 'Introducción',
                'site_selection_process' => 'Proceso de selección de sitio',
                'macro_location' => 'Macro localización',
                'micro_location' => 'Micro localización',
                'key_factors' => 'Factores clave en la selección del sitio',
                'methodology' => 'Metodología de la selección del sitio',
                'conclusion' => 'Conclusión',
                'due_diligence_methodology' => 'Metodología para la evaluación de diligencia debida en propiedades',
            ],
        ],
        'strategic_leadership' => [
            'title' => 'Liderazgo estratégico',
            'description1' => 'El liderazgo en proyectos de construcción es un equilibrio entre el arte y la ciencia. La ciencia implica la aplicación de metodologías, herramientas, métricas y buenas prácticas para planear, controlar y gestionar riesgos. El arte está en la capacidad del líder para influir, motivar, comunicar y gestionar las relaciones humanas, removiendo barreras y alineando los intereses de todos los stakeholders.',
            'description2' => 'El Project Manager (PM) debe desarrollar herramientas para liderar equipos de trabajo, reducir riesgos y alcanzar el éxito en el proyecto, gestionando de manera efectiva la comunicación, las lecciones aprendidas y los indicadores clave de valor ganado, costo, tiempo y alcance.',
        ],
        'quality_management' => [
            'title' => 'Gestión de calidad',
            'description1' => 'Planes de gestión, control de procedimientos y aseguramiento de la calidad.',
            'content' => [
                'preliminary_studies' => 'Estudios Preliminares',
                'earthworks' => 'Terracerías',
                'foundations' => 'Cimentaciones',
                'rainwater_design' => 'Diseño Pluvial',
                'metal_structure' => 'Estructura Metálica',
                'concrete_floors' => 'Pisos de Concreto',
                'tilt_up_walls' => 'Muros Tilt Up',
                'civil_works' => 'Obra Civil',
                'plumbing' => 'Plomería',
                'electrical_system' => 'Sistema Eléctrico',
                'air_conditioning_systems' => 'Sistema de Aires Acondicionados',
                'fire_systems' => 'Sistemas Contra Incendio',
                'special_systems' => 'Sistemas Especiales',
                'pavements' => 'Pavimentos',
                'exterior_works' => 'Obras Exteriores',
            ],
        ],
        'safety_hygiene' => [
            'title' => 'Seguridad e Higiene',
            'description1' => 'La profesión del Supervisor de Seguridad e higiene requiere de muchos conocimientos de normativas y de mucha disciplina, cada día cientos de procesos se realizan a la vez en especialidades distintas, el trabajo de seguridad es responsabilidad de todos los integrantes que trabajan en la construcción.',
            'description2' => 'El Project Manager debe de tener la capacidad de reconocer las prioridades de seguridad e higiene y al mismo tiempo debe de tener bien definido los protocolos y procedimientos de seguridad correctos, asumiendo el liderazgo desde la planeación durante la construcción y hasta el cierre total de la obra.',
            'content' => [
                'safety_manual' => 'Manual de seguridad e higiene',
                'safety_health_system' => 'Sistema de seguridad y salud en la obra',
                'safety_regulations' => 'Reglamento de seguridad',
                'golden_rules' => 'Reglas de oro de la seguridad',
                'osha_methodology' => 'Metodología de seguridad OSHA',
                'work_stoppage_policy' => 'Política de detención del trabajo',
                'safety_health_policy' => 'Política de seguridad y salud',
                'environmental_policy' => 'Política de medio ambiente',
                'contingency_procedure' => 'Procedimiento para contingencias',
                'hazardous_waste_control' => 'Control de residuos peligrosos',
                'site_cleanliness' => 'Limpieza e higiene en la obra',
                'fatality_report' => 'Reporte de fatalidad',
            ],
        ],
        'procurement' => [
            'title' => 'Adquisiciones',
            'description1' => 'El propósito fundamental es ejercer control sobre las reglas del proyecto, establecer un objetivo, común y claro, ayudar a los esfuerzos de los participantes para crear más y mejores proyectos que se traduzcan en oportunidades de crecimiento, para que el proyecto pueda ser fuerte y se desarrolle en armonía y genere prosperidad.',
            'content' => [
                'project_execution' => 'Ejecución del plan de proyecto.',
                'construction_bidding_strategy' => 'Estrategia y procesos de concurso de obra.',
                'project_scheduling' => 'Programación de tiempos del proyecto.',
                'parametric_costs' => 'Costos paramétricos.',
                'contractor_evaluation' => 'Evaluación de contratistas generales.',
                'supplier_code' => 'Código de conducta de proveedores.',
                'rfp_methodology' => 'Metodología para la elaboración de una RFP de diseño de proyecto ejecutivo.',
                'drawings_index' => 'Índice de planos.',
                'engineering_control' => 'Metodología para el control y revisión de avances de la ingeniería del proyecto ejecutivo.',
                'change_control' => 'Control de cambios en proyectos industriales.',
                'candiles_case_study' => 'Caso de estudio: reposicionamiento del centro comercial Candiles.',
                'codes_compliance' => 'Cumplimiento de normas y códigos de construcción.',
                'construction_bidding' => 'Concurso de obra y elaboración de RFP.',
                'five_rounds_technique' => 'Técnica de los 5 rounds – value to fee.',
                'savings_management' => 'Gestión de oportunidades de ahorro.',
                'feedback_methodology' => 'Metodología de retroalimentación y comunicación.',
                'schedule_of_values' => 'Schedule of values (catálogo de conceptos).',
                'value_engineering' => 'Ingeniería de valor.',
                'pm_improvements' => 'Mejoras en la metodología de project management en concursos industriales.',
                'contractor_selection' => 'Selección de contratista general.',
                'lessons_learned' => 'Retroalimentación, lecciones aprendidas y auditorías en concursos de obra.'
            ],
        ],
        'land_development' => [
            'title' => 'Land Development',
            'description1' => 'Los parques industriales son motores de empleo, innovación y desarrollo regional, capaces de transformar comunidades cuando se planifican con precisión y eficiencia. Con más de 75 años de experiencia combinada en bienes raíces industriales en México, nuestro equipo integra urbanismo, infraestructura, sostenibilidad, regulaciones y estrategia, aplicando metodologías certificadas del Project Management Institute para garantizar proyectos rentables, sostenibles y de alto impacto económico y social.',
            'description2' => 'Introducción a la metodología de parques industriales.',
            'content' => [
                'planning_process' => 'Proceso de planificación y ciclo de vida del proyecto.',
                'requirements_analysis' => 'Análisis de requerimientos.',
                'engineering_development' => 'Desarrollo de ingenierías.',
                'cost_time_management' => 'Gestión de costo y tiempo.',
                'parameters_definition' => 'Definición de parámetros.',
                'project_charter' => 'Acta de constitución del proyecto (Project Charter).',
                'legal_permits' => 'Marco legal y permisos.',
                'urban_regulations' => 'Regulaciones urbanas, ambientales y fiscales.',
                'ejidal_lands' => 'Dominio pleno sobre parcelas ejidales.',
                'land_use_permit' => 'Permiso de uso de suelo.',
                'mexican_standards' => 'Norma Mexicana de Parques Industriales y certificaciones.',
                'architectural_design' => 'Diseño arquitectónico y urbano.',
                'financial_analysis' => 'Análisis financiero de inversiones inmobiliarias.',
                'feasibility_study' => 'Estudio de factibilidad y punto de equilibrio.',
                'roi_valuation' => 'Retorno de inversión (ROI) y valuación.',
                'industrial_leasing' => 'Arrendamientos industriales.',
                'preliminary_studies' => 'Estudios preliminares y permisos de construcción.',
                'location_studies' => 'Ubicación, mecánica de suelos, impacto ambiental e hidrológico.',
                'utilities_feasibility' => 'Factibilidades (eléctrica, agua, drenaje, gas, accesos).',
                'urbanization_costs' => 'Análisis de costos de urbanización e infraestructura.',
                'technical_regulations' => 'Reglamento técnico y de construcción.',
                'general_provisions' => 'Disposiciones generales.',
                'design_committee' => 'Comité técnico de diseño y construcción.',
                'hydraulic_infrastructure' => 'Infraestructura hidráulica y privada.',
                'project_construction_operation' => 'Proyecto, construcción y operación.',
                'innovative_trends' => 'Tendencias innovadoras y estrategia comercial.',
                'additional_services' => 'Servicios adicionales y hubs privados.',
                'conclusions' => 'Conclusiones.'
            ],
        ],
        'strategic_planning' => [
            'title' => 'Planeación estratégica',
            'description1' => 'La metodología de Planeación Estratégica describe los procesos de gestión y herramientas para dar inicio al proyecto, asegurando el cumplimiento de los objetivos durante el ciclo de vida del proyecto.',
            'description2' => 'En esta etapa se planifica estratégicamente implementando el plan de Dirección del Proyecto, definiendo las líneas base costo, alcance y tiempo.',
            'description3' => 'Se firma el Project Charter, se establecen los planes de gestión de: alcance, tiempo, costos, calidad, riesgos, comunicación y adquisiciones.',
            'content' => [
                'project_initiation' => 'Inicio y planeación del proyecto',
                'project_sponsor' => 'El sponsor del proyecto',
                'objectives_vs_goals' => 'Objetivos de un proyecto vs. metas de un proyecto',
                'objectives_benefits' => 'Los beneficios de los objetivos de un proyecto',
                'project_lifecycle' => 'Ciclo de vida de un proyecto',
                'planning_stage' => 'Etapa de planeación del proyecto',
                'initiation_processes' => 'Procesos de inicio y planeación de un proyecto',
                'project_charter' => 'Acta de constitución del proyecto (Project Charter)',
                'project_direction_plan' => 'Plan para la dirección del proyecto',
                'scope_management' => 'Gestión del alcance',
                'time_management' => 'Gestión del tiempo',
                'cost_management' => 'Gestión de los costos',
                'quality_management' => 'Gestión de la calidad del proyecto',
                'human_resources_management' => 'Gestión de los recursos humanos',
                'communications_management' => 'Gestión de las comunicaciones del proyecto',
                'risk_management' => 'Gestión de los riesgos del proyecto',
                'procurement_management' => 'Gestión de adquisiciones del proyecto',
                'final_deliverables' => 'Entregables finales que comprenderán el resultado del proyecto',
                'scope_creep_what' => '¿Qué es el scope creep y cómo puedes evitarlo?',
                'scope_creep_why' => '¿Por qué pasa?',
                'scope_creep_how' => '¿Cómo podemos resolver el problema?',
                'change_management_what' => 'Gestión del cambio – ¿Qué es y para qué nos sirve?',
                'change_management_service' => 'Change Management – Servicio de consultoría',
                'change_management_factors' => 'Change Management – Factores clave de proceso',
                'escalation_matrix' => 'Matriz de escalamiento de roles y responsabilidades',
                'change_leadership_training' => 'Capacitación y liderazgo hacia el cambio',
            ],
        ],
        'construction_permits' => [
            'title' => 'Permisos de construcción',
            'description1' => 'Cada vez son más elaborados los procedimientos de los permisos de construcción, a través de este Playbook encontrarás una guía para prevenir contratiempos para iniciar la construcción, y la responsabilidad del D.R.O, los procedimientos de contratación para factibilidades de conexión de servicios eléctricos, agua y drenaje para sus nuevos proyectos.',
            'description2' => 'Nos enfocamos en la sustentabilidad del impacto ambiental, impacto vial, requisitos de Protección Civil para la seguridad de los usuarios del proyecto.',
            'description3' => 'Prevenimos contratiempos en la licencia de funcionamiento, evitando riesgos con los corresponsables estructurales, clausuras o multas con el IMSS, aseguramos no tener afectaciones durante la ejecución de la construcción.',
            'content' => [
                'introduction' => 'Introducción a los permisos de construcción',
                'permits_list' => 'Listado de permisos y normativa aplicable',
                'specialized_managers' => 'Gestores especializados y cumplimiento ético',
                'requirements_procedures' => 'Requisitos y procedimiento para permisos de construcción',
                'compliance_importance' => 'Importancia del cumplimiento normativo',
                'definitive_permit' => 'Permiso de construcción definitivo',
                'land_use_coefficients' => 'Uso de suelo y coeficientes (CUS, COS)',
                'director_responsibilities' => 'Responsabilidades del director responsable de obra y corresponsables',
                'urban_development_review' => 'Revisión de proyecto por desarrollo urbano',
                'civil_protection_approval' => 'Visto bueno de protección civil',
                'work_suspension' => 'Suspensión de obra',
                'traffic_impact' => 'Impacto vial (factibilidad, estudio, mitigación)',
                'environmental_impact' => 'Impacto ambiental (manifiesto, resolutivo, casos de estudio)',
                'services_connection' => 'Conexión de servicios: agua, drenaje y energía eléctrica',
                'imss_obligations' => 'Obligaciones legales y normativas del IMSS en proyectos de construcción',
                'civil_protection_permits' => 'Permisos y procesos de protección civil',
                'work_completion_procedure' => 'Procedimiento de terminación de obra',
            ],
        ],
        'construction_contract' => [
            'title' => 'Contrato de construcción',
            'description1' => 'La correcta implementación de la estrategia del contrato de construcción es una herramienta poderosa, define con claridad y precisión los objetivos del proyecto, provee importantes reglas de control y acelera dramáticamente el desarrollo del proyecto, creando beneficios que contribuyen al éxito del proyecto.',
            'description2' => 'M2M implementa estrategias profesionales, contribuyendo y aportando valor en esta colección de actividades.',
            'content' => [
                'contract_annexes_checklist' => 'Anexos de contratos check list',
                'lump_sum_contract' => 'Contrato a precio alzado',
                'guaranteed_maximum_price' => 'Contrato a precio máximo garantizado',
                'cost_plus_fee' => 'Contrato costo más utilidad',
                'unit_price_contract' => 'Contrato a precios unitarios',
                'letter_of_intent' => 'Carta de intención',
                'advance_invoice' => 'Factura de anticipo',
                'bonds' => 'Fianzas',
                'liability_insurance' => 'Seguro de responsabilidad civil',
                'submittal_authorization_format' => 'Formato de autorización de submittal',
                'submittal_authorization_procedure' => 'Procedimiento de autorización de submittal',
                'park_internal_regulations' => 'Reglamento interno del parque',
                'industrial_safety_regulations' => 'Reglamento de seguridad industrial e higiene',
                'imss_contractor_registration' => 'Alta ante el IMSS del contratista',
                'sat_registration_rfc' => 'Alta ante el SAT y copia del RFC del contratista',
                'technical_deliverables_index' => 'Índice de entregables técnicos y garantías',
                'work_organization_chart' => 'Organigrama de la obra, líneas de comunicación, matriz de roles y responsabilidades',
                'guarantee_fund_retention' => 'Aviso de retención de fondo de garantía',
                'monthly_progress_estimate' => 'Formato de estimación mensual de avance',
                'weekly_report_format' => 'Formato de reporte semanal',
                'change_order_format' => 'Formato de orden de cambio',
                'effective_change_procedure' => 'Procedimiento efectivo de órdenes de cambio',
                'beneficial_area_delivery' => 'Acta de entrega / recepción de área benéfica',
                'substantial_area_delivery' => 'Acta de entrega / recepción de área sustancial',
                'punch_list_format' => 'Formato de listado de detalles de punch list',
                'supplier_payment_letter' => 'Formato de carta de pagos a proveedores y finiquito de responsabilidad',
                'final_delivery_folders' => 'Índice de carpetas de entrega final',
                'final_delivery_reception' => 'Acta de entrega / recepción final',
            ],
        ],
        'closing_stage' => [
            'title' => 'Cierre de proyecto',
            'description1' => 'La etapa de cierre en un proyecto de construcción implica la finalización de todas las actividades, la entrega de los resultados al cliente, la evaluación del desempeño del proyecto y la disolución del equipo del proyecto.',
            'description2' => 'Es una fase crítica que marca el final exitoso del proyecto y proporciona una oportunidad para reflexionar sobre los logros y lecciones aprendidas durante todo el ciclo de vida del proyecto.',
            'content' => [
                'why_important' => '¿Por qué el cierre del proyecto es tan importante?.',
                'clear_next_steps' => 'Indica con claridad los próximos pasos.',
                'capture_lessons' => 'Captura las lecciones aprendidas.',
                'confirm_work_finished' => 'Confirma que el trabajo está terminado.',
                'how_know_finished' => '¿Cómo sabes cuándo un proyecto está realmente finalizado?.',
                'close_in_8_steps' => 'Cómo cerrar un proyecto en 8 pasos.',
                'administration_procedures' => 'Procedimientos de administración y supervisión en el cierre del proyecto.',
                'work_termination' => 'Terminación de obra o cierre.',
                'punch_list' => 'Listado de pendientes "Punch List".',
                'release_of_liens' => 'Cartas de no adeudo a proveedores "Release of Leans".',
                'work_reception_acts' => 'Actas de recepción de obra.',
                'beneficial_delivery_act' => 'Acta de entrega benéfica.',
                'substantial_delivery_act' => 'Acta de entrega sustancial.',
                'final_delivery_act' => 'Acta de entrega final.',
                'commissioning_protocol' => 'Comisionamiento protocolo de pruebas.',
                'imss_no_debt_letter' => 'Carta de no adeudo ante el IMSS SIROC (Registro de obra del Seguro Social).',
                'as_built_delivery' => 'Entrega y revisión de planos As-Built y de manuales y garantías.',
                'hidden_defects_bond' => 'Fianza de vicios ocultos.',
                'work_completion' => 'Terminación de obra.',
                'improper_completion' => 'Terminación de obra improcedente.',
                'final_report' => 'Reporte final.'
            ],
        ],
        'project_design' => [
            'title' => 'Diseño del proyecto',
            'description1' => 'Metodología Plan Maestro Ejecución de Diseño.',
            'description2' => 'La correcta implementación del control del desarrollo de la ingeniería depende de un plan estratégico, la ejecución exige un control y monitoreo, reduce riesgos, proveen buenos resultados y ahorros para los clientes.',
            'content' => [
                'objective_distinction' => 'Objetivo, Distinción y Quiénes Somos.',
                'client_value_management' => 'Valor para el Cliente y Gestión Colaborativa.',
                'm2m_pdb_consulting' => 'M2M Consultoría PDB (Program Development and Building).',
                'design_execution_process' => 'Proceso de Ejecución del Diseño del Proyecto.',
                'master_plan_implementation' => 'Implementación y Seguimiento del Plan Maestro.',
                'control_dashboards' => 'Tableros de Mando y Control de Información (Power BI).',
                'bim_modeling' => 'Modelado BIM LOD 200 y Control con Navisworks.',
                'lean_construction_strategy' => 'Estrategia de Contratación y Acompañamiento Lean Construction.',
                'objectives_alignment' => 'Metodología de Alineación de Objetivos.',
                'project_plan_execution' => 'Ejecución del Plan del Proyecto.',
                'scope_definition_control' => 'Definición y Control del Alcance.',
                'performance_monitoring' => 'Monitoreo del Desempeño y Técnicas de Valor Ganado (EVM).',
                'design_management_software' => 'Herramientas de Software para Gestión del Diseño.',
                'agile_lean_methodologies' => 'Aplicación de Metodologías Ágil y Lean Construction.',
                'stakeholder_communication' => 'Comunicación Efectiva y Gestión de Stakeholders.',
                'quality_control_risks' => 'Control de Calidad e Identificación de Riesgos.',
                'space_planning_analysis' => 'Planeación y Análisis de Espacios / Anteproyecto.',
                'supplier_code_rfps' => 'Código de Conducta de Proveedores y RFPs.',
                'drawings_index_control' => 'Índice de Planos y Control de Avances.',
                'change_control_compliance' => 'Control de Cambios, Matriz de Trazabilidad y Cumplimiento Normativo.',
                'technical_financial_requirements' => 'Requerimientos Técnicos y Financieros.',
                'schedule_of_values_catalog' => 'Catálogo de Conceptos – Schedule of Values.'
            ],
        ],
        'data_center' => [
            'title' => 'Data Center',
            'description1' => 'Vivimos en una era marcada por la interconectividad global, donde los Data Centers son el motor invisible que permite el flujo constante de información, sosteniendo desde el teletrabajo y la educación a distancia hasta las innovaciones en ciudades inteligentes y vehículos autónomos. La pandemia aceleró esta transformación, confirmando que estas infraestructuras son pilares esenciales de la vida moderna y del futuro digital.',
            'description2' => 'Con experiencia en proyectos de alcance nacional e internacional, nuestro equipo de Project Managers ha participado en desarrollos que van desde centros tecnológicos para multinacionales hasta soluciones de iluminación inteligente. Este manual busca no solo resaltar la importancia estratégica de los Data Centers, sino también inspirar a quienes desean ser parte activa de esta revolución tecnológica.',
            'content' => [
                'digital_revolution' => 'La Revolución de la Era Digital y su Dependencia en los Data Centers.',
                'mexico_background' => 'Antecedentes y Evolución en México.',
                'digital_gap' => 'Oportunidades y Brecha Digital.',
                'intelligent_networks' => 'Data Centers y Redes Inteligentes ("Human Networks").',
                'data_center_types' => 'Tipos y Componentes de Centros de Datos.',
                'costs_standards_tiers' => 'Costos, Estándares y Tiers.',
                'development_infrastructure' => 'Desarrollo e Infraestructura.',
                'location_electrical_analysis' => 'Ubicación y Análisis de Red Eléctrica.',
                'architectural_design' => 'Diseño Arquitectónico y Espacios.',
                'redundancy_efficiency' => 'Redundancia y Eficiencia Energética.',
                'speed_storage_mmr' => 'Velocidad, Almacenamiento y MMR.',
                'studies_planning' => 'Estudios y Planificación.',
                'needs_evaluation' => 'Evaluación de Necesidades.',
                'financial_viability' => 'Viabilidad Financiera.',
                'electrical_cooling_design' => 'Diseño de Electricidad, Refrigeración, Red y Seguridad.',
                'risk_management' => 'Gestión de Riesgos y Cumplimiento Normativo.',
                'permits_land_acquisition' => 'Permisos y Adquisición de Terreno.',
                'fire_systems_latency' => 'Sistemas contra incendio y Latencia.',
                'industrial_parks_maintenance' => 'Parques Industriales, Infraestructura y Mantenimiento.',
                'costs_leasing_roi' => 'Costos, Arrendamientos y ROI.',
                'conclusion' => 'Conclusión.'
            ],
        ],
        'cost_management' => [
            'title' => 'Cost Management',
            'description1' => 'La correcta planeación financiera, administración y control de la línea base del costo en los proyectos es una de las tres prioridades de los Project Managers.',
            'description2' => 'La Metodología del Control del Costo provee importantes herramientas para predeterminar costos paramétricos de construcción de diferentes tipos de edificios proyectos, que nos permiten gestionar al proceso de aprobación del capital de inversión y equipamientos, proveemos valores justos de mercado para las inversiones extranjeras.',
            'content' => [
                'cost_administration_intro' => 'Introducción a la administración del costo.',
                'project_direction_plan' => 'Plan para la dirección del proyecto.',
                'cost_management_planning' => 'Gestión y planeación del costo.',
                'parametric_budget' => 'Presupuesto paramétrico.',
                'industrial_building_classification' => 'Clasificación de edificios industriales.',
                'speculative_building_classes' => 'Edificio especulativo y clases de naves industriales.',
                'engineering_control_monitoring' => 'Control y monitoreo de la ingeniería del proyecto.',
                'construction_costs' => 'Costos de construcción.',
                'materials_labor_machinery' => 'Materiales, mano de obra y maquinaria.',
                'fixed_costs_consumption' => 'Costos fijos y consumos.',
                'crews_performance' => 'Cuadrillas y rendimientos.',
                'mixtures_dosage_analysis' => 'Análisis de mezclas y dosificaciones.',
                'building_technical_questionnaire' => 'Cuestionario técnico del edificio.',
                'concepts_catalog' => 'Catálogo de conceptos (Schedule of values).',
                'final_report_lessons' => 'Reporte final y lecciones aprendidas.',
                'conclusion' => 'Conclusión.'
            ],
        ],
        'control_monitoring' => [
            'title' => 'Control y monitoreo',
            'description1' => 'El Monitoreo y Control del Proyecto es fundamental para evaluar su estado actual, detectar posibles problemas y tomar decisiones preventivas o correctivas. Estas acciones pueden implicar ajustes en el plan original, asegurando que el proyecto se mantenga alineado con sus objetivos.',
            'description2' => 'Los Construction Project Managers emplean herramientas y procesos especializados para supervisar y controlar el proyecto, garantizando que se complete conforme a los objetivos establecidos en el plan de gestión del proyecto.',
            'description3' => 'El desglose estructurado del trabajo (WBS, por sus siglas en inglés) permite rastrear, evaluar y regular el progreso, el rendimiento y cualquier cambio necesario en el proyecto, identificando de manera oportuna las áreas que requieren ajustes en el plan.',
            'content' => [
                'performance_control_tools' => 'Herramientas para control y monitoreo del desempeño.',
                'scope_requirements_management' => 'Gestión del alcance, requisitos y entregables.',
                'traceability_matrix' => 'Matriz de trazabilidad.',
                'work_breakdown_structure' => 'Desglose estructurado del trabajo.',
                'change_requests' => 'Solicitudes de cambio.',
                'performance_reports' => 'Informes de desempeño.',
                'time_control_monitoring' => 'Control y monitoreo del tiempo.',
                'cost_control_monitoring' => 'Control y monitoreo de los costos.',
                'quality_control_monitoring' => 'Control y monitoreo de la calidad.',
                'hr_control_monitoring' => 'Control y monitoreo de recursos humanos.',
                'communications_control_monitoring' => 'Control y monitoreo de las comunicaciones.',
                'risk_control_monitoring' => 'Control y monitoreo de riesgos.',
                'procurement_control_monitoring' => 'Control y monitoreo de adquisiciones.'
            ],
        ],
        'site_selection_process' => [
            'title' => 'Site Selection Process',
            'description1' => 'El servicio especializado de Due Diligence y Selección de Sitio está adquiriendo una relevancia creciente en los proyectos más importantes a nivel mundial.',
            'description2' => 'Un análisis exhaustivo de las características legales, ambientales, hidrológicas y geológicas, así como de los servicios locales e infraestructura, proporciona información crucial para la toma de decisiones informadas en las inversiones de nuestros clientes.',
            'content' => [
                'site_selection_guide_mexico' => 'Guía para la selección del sitio en México.',
                'introduction' => 'Introducción.',
                'site_selection_process' => 'Proceso de selección del sitio.',
                'key_selection_factors' => 'Factores clave en la selección del sitio.',
                'site_selection_methodology' => 'Metodología de selección del sitio.',
                'conclusion' => 'Conclusión.',
                'due_diligence_methodology' => 'Metodología para la evaluación de diligencia debida en propiedades.',
                'land_use_feasibility' => 'Factibilidad de uso de suelo.',
                'land_cost_proposals' => 'Propuestas económicas de costo de tierra.',
                'land_alternatives_cost_matrix' => 'Matriz de costo de alternativas de terreno.',
                'technical_acquisition_study' => 'Estudio técnico de adquisición de terreno / Due Dilligence.',
                'phase_one_study' => 'Estudio "Phase One".',
                'hydrological_study' => 'Estudio hidrológico.',
                'hydrological_importance_case' => 'Casos de estudio: La importancia del estudio hidrológico.',
                'hydrological_process' => 'Proceso del estudio hidrológico.',
                'conclusion_hydro' => 'Conclusión.',
                'soil_mechanics_study' => 'Estudio de mecánica de suelos.',
                'environmental_accreditation' => 'Acreditación ambiental.',
                'land_purchase_contract' => 'Contrato de compra de la tierra.',
                'property_evaluation_study' => 'Estudio técnico de la evaluación de propiedades.',
                'building_classification_criteria' => 'Criterios de clasificación de edificios.',
                'negotiation_strategy' => 'Estrategia de negociación para la atracción de proyectos industriales.',
                'investment_profile' => 'Perfil de inversión.',
                'government_letter_intent' => 'Carta de intención para el gobierno.'
            ],
        ],
    ],
    'contact' => [
        'title' => 'Contáctanos',
        'quote' => '"El éxito en la construcción 
        no solo depende de los 
        planos, sino de la pasión y 
        liderazgo del equipo."',
        'email_us' => 'Escríbenos a',
        'call_us' => 'o llama al:',
        'form_title' => 'O déjanos tus datos y nosotros te contactamos',
        'name' => 'Nombre',
        'phone' => 'Número de teléfono',
        'email' => 'Correo',
        'send' => 'Enviar',
        'social_networks' => 'Encuéntranos en redes',
    ],
    'common' => [
        'back_to_top' => 'Ir al inicio',
        'inicio' => 'Inicio',
        'close' => 'Cerrar',
        'more_info' => 'Más información',
        'learn_more' => 'Conoce más',
        'previous' => 'Anterior',
        'next' => 'Siguiente',
    ],
];
?>