document.addEventListener('DOMContentLoaded', function () {
    //  Función para manejar un carousel genérico
    function initCustomCarousel(carouselId, indicatorsSelector) {
        const carousel = document.getElementById(carouselId);
        const indicators = document.querySelectorAll(indicatorsSelector);

        if (!carousel || indicators.length === 0) return;

        const bsCarousel = new bootstrap.Carousel(carousel);

        carousel.addEventListener('slide.bs.carousel', function (event) {
            indicators.forEach(ind => ind.classList.remove('active'));
            if (indicators[event.to]) {
                indicators[event.to].classList.add('active');
            }
        });

        indicators.forEach((indicator, idx) => {
            indicator.addEventListener('click', function () {
                bsCarousel.to(idx);
            });
        });
    }

    //  Inicializa múltiples carousels si existen
    initCustomCarousel('carouselExampleIndicators', '.custom-indicators span');
    initCustomCarousel('carouselExampleIndicators2', '.custom-indicators2 span');

    //  Cierre del modal con botón personalizado
    const closeModalBtn = document.querySelector('.close-modal');
    const modalEl = document.getElementById('projectManagement');
    if (closeModalBtn && modalEl) {
        const modalInstance = bootstrap.Modal.getInstance(modalEl);
        closeModalBtn.addEventListener('click', function () {
            modalInstance?.hide();
        });
    }

    // Toggle de sublistas tipo acordeón en .modal-ul
    /*const parentItems = document.querySelectorAll('.modal-ul > li');

    parentItems.forEach(item => {
        const subList = item.querySelector('ul');
        if (subList) {
            item.addEventListener('click', function (e) {
                if (e.target !== item) return;
                item.classList.toggle('open');
            });
        }
    }); 

    //  Abre el primer <li> que tenga sublista al cargar la página
    const firstWithSubList = document.querySelector('.modal-ul > li ul')?.parentElement;
    if (firstWithSubList) {
        firstWithSubList.classList.add('open');
    }*/
}); 
