<?php include 'views/head.php' ?>

<section class="eleven-section">
    <img src="img/banners/bannerSimulador.jpg" alt="" class="els-img">
    <div class="els-div2">
        <p class="els-p">Simulador de costos</p>
        <p class="els-p2">Potencie sus proyectos con precisión.</p>
    </div>
</section>

<section class="twelve-section">
    <div class="tws-div">
        <p class="tws-p5">Simulador de costos</p>
        <img src="img/lineaVerde.png" alt="" class="tws-img3">
        <div class="row">
            <div class="col-md-6">
                <p class="tws-p3" style="margin-bottom: 25px;">Descubre una forma mas inteligente de planificar las finanzas de su proyecto con nuestro innovador Simulador de costos.</p>
                <p class="tws-p2">Diseñada para proporcionar estimaciones precisas, esta herramienta le permite explorar multiples escenarios de costes de construcción y crear presupuestos preliminares para mejoras de capital, ampliaciones y nuevas construcciones.</p>
            </div>
            <div class="col-md-6">
                <p class="tws-p2">Tenga en cuenta que los costes generados por el simulador son estimaciones y pueden variar en función de los cambios en el alcance del proyecto, las condiciones del mercado y otras variables. Con esta herramienta, obtendrá información valiosa para tomar decisiones informadas, optimizar su presupuesto y convertir su visión en realidad con confianza.</p>
            </div>

        </div>

        <div class="tws-div3">
            <p class="tws-p6">Introduzca los requerimientos para el presupuesto estimado de su proyecto</p>
            <div class="progress">
                <div class="progress-bar" role="progressbar" style="width: 25%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">Step 1 of 4</div>
            </div>

            <form id="quotationForm" class="row g-3 needs-validation" novalidate enctype="multipart/form-data">
                <!-- PASO 1: Dimensiones del proyecto -->
                <div class="form-section">
                    <p class="simulator-p">1. Dimensiones del proyecto</p>
                    <hr class="simulator-hr">
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-3">
                                <label for="storageSpace" class="form-label simulator-fl">
                                    Espacio de almacenamiento
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Área destinada para el almacenamiento de productos o materiales en metros cuadrados"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="storageSpace" name="storageSpace" placeholder="500 - 1000" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca el espacio de almacenamiento.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="productionSpace" class="form-label simulator-fl">
                                    Espacio de producción
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Área destinada para actividades de manufactura o producción en metros cuadrados"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="productionSpace" name="productionSpace" placeholder="300 - 600" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca el espacio de producción.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="mezanine" class="form-label simulator-fl">
                                    Área de mezzanine
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Piso intermedio entre dos plantas principales de un edificio que maximiza el espacio disponible"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="mezanine" name="mezanine" placeholder="150 - 300" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca el área de mezzanine.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="footprintWarehouse" class="form-label simulator-fl">
                                    Área del almacén
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Superficie total ocupada por la estructura del almacén en metros cuadrados"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="footprintWarehouse" name="footprintWarehouse" placeholder="1000 - 2000" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca el área del almacén.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-3">
                                <label for="officeSpace" class="form-label simulator-fl">
                                    Oficinas
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Espacio destinado para oficinas administrativas y de gestión en metros cuadrados"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="officeSpace" name="officeSpace" placeholder="100 - 200" required>
                                <div class="invalid-feedback">
                                    Por favor introduzca el espacio de la oficina.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="outsideTerrain" class="form-label simulator-fl">
                                    Área exterior / patios
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Espacios exteriores como patios, áreas de maniobra y estacionamientos en metros cuadrados"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="outsideTerrain" name="outsideTerrain" placeholder="200 - 500" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca el área exterior.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="footprintTotalSite" class="form-label simulator-fl">
                                    Superficie total de la planta
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Área total del terreno que ocupará el proyecto, incluyendo construcciones y exteriores"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="footprintTotalSite" name="footprintTotalSite" placeholder="1200 - 2500" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca la superficie total de la planta.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="purchasePriceLand" class="form-label simulator-fl">
                                    Precio de compra del terreno
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Costo estimado de adquisición del terreno en pesos mexicanos por metro cuadrado"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="purchasePriceLand" name="purchasePriceLand" placeholder="50-150" required>
                                <div class="invalid-feedback">
                                    Introduzca el precio de compra del terreno.
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn btn-next next">Siguiente</button>
                </div>
                <!-- PASO 2: Características del almacén -->
                <div class="form-section">
                    <p class="simulator-p">2. Características del almacén</p>
                    <hr class="simulator-hr">
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <label for="clearHeightStorageArea" class="form-label simulator-fl">
                                    Altura libre de almacenamiento
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Altura disponible desde el suelo hasta el techo para almacenamiento en metros"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="clearHeightStorageArea" name="clearHeightStorageArea" placeholder="11 - 12" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca la zona de almacenamiento de altura libre.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="numberOfLoadingDocks" class="form-label simulator-fl">
                                    Número de muelles de carga
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Cantidad de muelles o plataformas de carga para camiones"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="numberOfLoadingDocks" name="numberOfLoadingDocks" placeholder="4" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca el número de muelles de carga.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="numberOfLoadingDoors" class="form-label simulator-fl">
                                    Número de puertas de carga
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Cantidad de puertas para carga y descarga de mercancías"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="numberOfLoadingDoors" name="numberOfLoadingDoors" placeholder="8 - 24 puertas" required>
                                <div class="invalid-feedback">
                                    Introduzca el número de puertas de carga.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <label for="maxFloorLoadCapacity" class="form-label simulator-fl">
                                    Capacidad de carga máxima del suelo
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Peso máximo que puede soportar el suelo por metro cuadrado en toneladas"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="maxFloorLoadCapacity" name="maxFloorLoadCapacity" placeholder="5" required>
                                <div class="invalid-feedback">
                                    Introduzca la capacidad de carga máxima del suelo.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="maxFloorLoadCapacityMezanineArea" class="form-label simulator-fl">
                                    Capacidad máxima del mezzanine
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Peso máximo que puede soportar el mezzanine por metro cuadrado en toneladas"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control numeric-only" id="maxFloorLoadCapacityMezanine" name="maxFloorLoadCapacityMezanineArea" placeholder="250 - 500" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca la capacidad de carga máxima del mezzanine área.
                                </div>
                            </div>
                            <div class="col-md-4 simulator-col">
                                <div>
                                    <label class="form-check-label simulator-fl" for="foundationRequired">
                                        Se requiere cimentación
                                        <i class="bi bi-question-circle"
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            title="Marque esta casilla si su proyecto requiere la construcción de nueva cimentación"
                                            style="cursor: help; font-size: 0.8em;"></i>
                                    </label>
                                    <input class="form-check-input" type="checkbox" value="yes" id="foundationRequired" name="foundationRequired">
                                </div>
                                <div>
                                    <label class="form-check-label simulator-fl" for="fireWallsAndDoors">
                                        Paredes y puertas cortafuegos
                                        <i class="bi bi-question-circle"
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            title="Elementos de seguridad contra incendios para contener el fuego"
                                            style="cursor: help; font-size: 0.8em;"></i>
                                    </label>
                                    <input class="form-check-input" type="checkbox" value="yes" id="fireWallsAndDoors" name="fireWallsAndDoors">
                                </div>
                            </div>
                        </div>
                    </div>
                
                    <button type="button" class="btn btn-next next">Siguiente</button>
                </div>

                <!-- PASO 3: Servicios -->
                <div class="form-section">
                    <p class="simulator-p">3. Servicios</p>
                    <hr class="simulator-hr">
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <label for="climateControlHeating" class="form-label simulator-fl">
                                    Climatización
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Sistema de control de temperatura y ventilación para el edificio"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <select name="climateControlHeating" id="climateControlHeating" class="form-select" required>
                                    <option value="">Seleccionar</option>
                                    <option value="HVAC">HVAC</option>
                                    <option value="SWAMP coolers">Enfriadores SWAMP</option>
                                    <option value="No Air Conditioning">Sin aire acondicionado</option>
                                </select>
                                <div class="invalid-feedback">
                                    Por favor, seleccione la opción de climatización.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="securityGate" class="form-label simulator-fl">
                                    Puerta de seguridad
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Sistema de acceso controlado para la entrada principal del complejo"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="securityGate" name="securityGate" placeholder="Portón deslizante automatizado" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca la puerta de seguridad.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label simulator-fl">
                                    Protección contra incendios - rociadores
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Sistema de rociadores automáticos para protección contra incendios"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <select name="fireProtectionSprinkler" id="fireProtectionSprinkler" class="form-select" required>
                                    <option value="">Seleccionar</option>
                                    <option value="NFPA">NFPA</option>
                                    <option value="FM">FM</option>
                                </select>
                                <div class="invalid-feedback">
                                    Por favor, seleccione la opción de protección contra incendios.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <label for="securityFence" class="form-label simulator-fl">
                                    Valla de seguridad
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Cercado perimetral para protección y delimitación del área del proyecto"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="securityFence" name="securityFence" placeholder="Valla perimetral de 3 metros" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca la valla de seguridad.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="burglarAlarm" class="form-label simulator-fl">
                                    Alarma antirrobo
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Sistema de detección y alarma para prevenir intrusiones"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="burglarAlarm" name="burglarAlarm" placeholder="Alarma con sensores de movimiento" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca la alarma antirrobo.
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label simulator-fl">
                                    Entorno de oficina
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Nivel de equipamiento y acabados para las áreas de oficina"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <select class="form-select" id="officeSetting" name="officeSetting" required>
                                    <option value="">Seleccionar</option>
                                    <option value="Básica">Básica</option>
                                    <option value="Equipada">Equipada</option>
                                    <option value="Premium">Premium</option>
                                </select>
                                <div class="invalid-feedback">
                                    Por favor, seleccione el entorno de oficina.
                                </div>
                            </div>
                        </div>
                    </div>
                
                    <button type="button" class="btn btn-next next">Siguiente</button>
                </div>

                <!-- PASO 4: Información Personal (ÚLTIMO) -->
                <div class="form-section">
                    <div class="text-center mb-4">
                        <h4 style="color: #1e1e1e; margin-top:25px">¡Tu presupuesto paramétrico está listo!</h4>
                        <p class="lead" style="color: #1e1e1e;">Compártenos tus datos para enviártelo por correo.</p>
                        <p class="text-muted small" style="color: #1e1e1e !important;">
                            <i class="bi bi-shield-check me-1"></i>
                            Toda tu información está protegida bajo nuestra política de privacidad y confidencialidad.
                        </p>
                    </div>

                    <p class="simulator-p">4. Información de Contacto</p>
                    <hr class="simulator-hr">
                    <div class="mb-3">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="name" class="form-label simulator-fl">
                                    Nombre Completo
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Ingrese su nombre completo tal como aparece en documentos oficiales"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="name" name="name" placeholder="ej.: Ricardo Pérez" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca su nombre.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="email" class="form-label simulator-fl">
                                    Email
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Dirección de correo electrónico válida donde recibirá la cotización"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="ej.: ricardo.perez@example.com" pattern="[a-z0-9._%+\-]+@[a-z0-9.\-]+\.[a-z]{2,}" required>
                                <div class="invalid-feedback">
                                    Introduzca una dirección de correo electrónico válida.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="phone" class="form-label simulator-fl">
                                    Teléfono
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Número de teléfono para contacto directo sobre el proyecto"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="tel" class="form-control numeric-only" id="phone" name="phone" placeholder="ej.: 5551234567" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca su número de teléfono.
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="company" class="form-label simulator-fl">
                                    Empresa
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Nombre de la empresa u organización para la cual se realizará el proyecto"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="company" name="company" placeholder="ej.: Acme S.A. de C.V." required>
                                <div class="invalid-feedback">
                                    Introduzca el nombre de su empresa.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="linkedin" class="form-label simulator-fl">
                                    LinkedIn (opcional)
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Su perfil de LinkedIn para establecer conexiones profesionales"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="linkedin" name="linkedin" placeholder="ej.: ricardo-perez">
                            </div>
                            <div class="col-md-3">
                                <label for="country" class="form-label simulator-fl">
                                    País
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="País donde se desarrollará el proyecto de construcción"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="country" name="country" placeholder="ej.: México" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca su país.
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="state" class="form-label simulator-fl">
                                    Ubicación
                                    <i class="bi bi-question-circle"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top"
                                        title="Ciudad o región específica donde se ubicará el proyecto"
                                        style="cursor: help; font-size: 0.8em;"></i>
                                </label>
                                <input type="text" class="form-control" id="location" name="location" placeholder="ej.: Ciudad de México" required>
                                <div class="invalid-feedback">
                                    Por favor, introduzca su ubicación.
                                </div>
                            </div>
                            <input type="hidden" name="dateOfRegistration" value="<?php echo date('Y-m-d'); ?>">
                        </div>
                    </div>

                    <button type="submit" class="btn btn-next">Enviar Mi Cotización</button>
                </div>
            </form>
        </div>
    </div>

</section>

<?php include 'views/footer.php' ?>