<?php
return [
    'nav' => [
        'nosotros' => 'About',
        'servicios' => 'Services',
        'proyectos' => 'Projects',
        'simulador' => 'Simulator',
        'reclutamiento' => 'Recruitment',
        'contactanos' => 'Contact',
    ],
    'home' => [
        'carousel' => [
            'slide1' => [
                'title' => 'Engineering and Project 
                Management Services',
                'description' => 'Our consultants bring decades of experience 
                working throughout Mexico, United States, and Latin America.',
            ],
            'slide2' => [
                'title' => 'We are a network of 
                professional human 
                resources throughout 
                Mexico.',
                'description' => 'Our experienced executives have contributed
                to the establishment of 78 multinational companies in Mexico.',
            ],
            'slide3' => [
                'title' => 'Proven methodology 
                for world-class 
                industrial projects',
                'description' => 'Our methodology ensures that every project 
                phase meets the highest international standards, 
                generating industrial parks that exceed expectations 
                and offer sustainable returns.',
            ],
        ],
        'about' => [
            'title' => 'ABOUT US',
            'subtitle' => 'We don\'t just manage 
            projects, we guide 
            companies through 
            every step of their 
            expansion in Mexico.',
            'description' => 'Our consultants bring decades of experience working 
            throughout Mexico, United States, and Latin America.',
            'description2' => 'Throughout this time, experienced executives have 
            contributed to the establishment of 78 multinational 
            companies in Mexico.',
            'stats' => [
                'companies' => '+78',
                'companies_text' => 'Multinational Companies',
                'experience' => 'Decades of experience',
            ],
        ],
        'different' => [
            'title' => 'What makes us different',
            'connection_title' => 'Our ability to connect with clients',
            'connection_description' => 'Throughout this time, experienced executives have contributed to the establishment of 78 multinational companies in Mexico.',
            'solutions_title' => 'Solutions-oriented approach',
            'solutions_description' => 'We focus on what more we can do to achieve success for you.',
            'services_description' => 'We offer project management services through a local team in Mexico.',
            'methodology_description' => 'Our project managers, backed by the M2M methodology, ensure high standards of ethics, service, professionalism, transparency, and continuous improvement, providing added value and significant savings in every construction.',
        ],
        'experience' => [
            'title' => 'More than 28 years',
            'description' => 'Working for the largest Industrial 
            Development Companies in Mexico, 
            industrial and commercial knowledge 
            is at your service.',
        ],
        'services' => [
            'title' => 'OUR SERVICES',
            'subtitle' => 'Solutions for your project',
            'description' => 'We offer a wide range of specialized services to accompany you at every stage of your industrial project.',
            'what_we_can_do' => 'What we can do for you',
            'engineering' => [
                'title' => 'Engineering',
                'description' => 'We design precise and efficient 
                technical solutions for every stage of your project.',
            ],
            'project_management' => [
                'title' => 'Construction Project Management',
                'description' => 'We plan, coordinate and execute with excellence 
                to guarantee results on time and within budget.',
            ],
            'due_diligence' => [
                'title' => 'Due diligence (site selection)',
            ],
            'cost_management' => [
                'title' => 'Cost management',
            ],
            'engineering_planning' => [
                'title' => 'Engineering design and planning',
            ],
            'construction_permits' => [
                'title' => 'Construction permits process',
            ],
            'procurement_bidding' => [
                'title' => 'Procurement bidding process',
            ],
            'construction_control' => [
                'title' => 'Construction control agreement',
            ],
            'construction_guidelines' => [
                'title' => 'Construction guidelines',
            ],
            'health_safety' => [
                'title' => 'Health and safety guidelines',
            ],
            'project_closure' => [
                'title' => 'Project closure',
            ],
        ],
        'recruitment' => [
            'title' => 'Join our team!',
            'subtitle' => 'We are looking for talent like yours.',
            'description' => 'Your next professional challenge starts here. 
            Discover our vacancies!',
            'apply_now' => 'Apply now!',
        ],
        'blackbook' => [
            'title' => 'BLACKBOOK',
            'subtitle' => 'Meet BlackBook, our learning platform',
            'description1' => 'We create highly specialized Construction Project Managers with multidisciplinary knowledge, who execute with high management and leadership, macro construction projects.',
            'description2' => 'BlackBook\'s Project Management methodology brings together more than 1,500 topics that analyze, control, measure and review the entire life cycle of a project. It includes training tools for engineers and architects seeking to become certified as Project Managers.',
            'visit_site' => 'Visit site',
        ],
        'playbooks' => [
            'title' => '+24 Playbooks',
            'description1' => 'The Project Manager profession requires extensive technical knowledge and the ability to coordinate multiple processes and specialties simultaneously.',
            'description2' => 'It involves differentiating project properties, defining the correct construction procedure and leading in an interdisciplinary environment, from planning to total project closure.',
            'intro_pm' => 'Introduction to Project Management',
            'strategic_leadership' => 'Strategic Leadership',
            'quality_management' => 'Quality Management',
            'safety_hygiene' => 'Safety & Hygiene',
            'procurement' => 'Procurement',
            'land_development' => 'Land Development',
            'strategic_planning' => 'Strategic Planning',
            'construction_permits' => 'Construction Permits',
            'construction_contract' => 'Construction Contract',
            'closing_stage' => 'Closing Stage',
            'project_design' => 'Project Design',
            'data_center' => 'Data Center',
            'cost_management' => 'Cost Management',
            'control_monitoring' => 'Control and Monitoring',
            'site_selection_process' => 'Site Selection Process',
            'clean_rooms' => 'Clean Rooms',
            'investment_funds' => 'Investment Funds',
            'new_cities' => 'New Cities',
            'speculative' => 'Speculative',
            'commissioning' => 'Commissioning',
            'case_study' => 'Case Study',
            'risk_management' => 'Risk Management',
        ],
        'recent_projects' => [
            'title' => 'Recent Projects',
            'description' => 'Every project is an opportunity to demonstrate our experience and commitment.',
            'view_projects' => 'View projects',
        ],
    ],
    'projects' => [
        'hero' => [
            'title' => 'Recent Projects',
            'description' => 'Every project is an opportunity to demonstrate our 
            experience and commitment.',
            'description2' => 'From complex industrial works to large-scale developments, 
            we deliver results that meet and exceed our clients\' expectations.',
        ],
        'horizon' => [
            'title' => 'Horizon Industrial Park',
            'description' => 'The first speculative building will feature 11,832 m² of covered area, perfect for storage, light manufacturing, e-commerce and more. Strategically located with easy access to highways and railways.',
            'area_label' => 'Area:',
            'area_value' => '32 Hectares in Phase 1',
            'services_label' => 'Services provided:',
            'project_management' => 'Project management',
            'bim' => 'BIM',
        ],
        'cisef' => [
            'title' => 'CISEF Industrial Park',
            'description' => 'CISEF Industrial Park is strategically located in Gómez Palacio, Durango, Mexico within a free trade zone designed to boost your foreign trade operations.',
            'area_label' => 'Area:',
            'area_value' => '141 Hectares',
            'services_label' => 'Services provided:',
            'project_management' => 'Project management',
            'bim' => 'BIM',
        ],
    ],
    'simulator' => [
        'hero' => [
            'title' => 'Cost Simulator',
            'subtitle' => 'Empower your projects with precision.',
        ],
        'main' => [
            'title' => 'Cost Simulator',
            'description1' => 'Discover a smarter way to plan your project finances with our innovative Cost Simulator.',
            'description2' => 'Designed to provide accurate estimates, this tool allows you to explore multiple construction cost scenarios and create preliminary budgets for capital improvements, expansions and new construction.',
            'description3' => 'Please note that the costs generated by the simulator are estimates and may vary based on changes in project scope, market conditions and other variables. With this tool, you will gain valuable insights to make informed decisions, optimize your budget and turn your vision into reality with confidence.',
            'form_intro' => 'Enter the requirements for your project\'s estimated budget',
            'step_indicator' => 'Step 1 of 4',
        ],
        'form' => [
            'step1' => [
                'title' => '1. Project Dimensions',
                'storage_space' => 'Storage space',
                'storage_space_tooltip' => 'Area designated for product or material storage in square meters',
                'production_space' => 'Production Space',
                'production_space_tooltip' => 'Area designated for manufacturing or production activities in square meters',
                'mezanine_area' => 'Mezzanine',
                'mezanine_tooltip' => 'Intermediate floor between two main floors of a building that maximizes available space',
                'warehouse_area' => 'Footprint Warehouse',
                'warehouse_tooltip' => 'Total area occupied by the warehouse structure in square meters',
                'office_space' => 'Offices space',
                'office_tooltip' => 'Space designated for administrative and management offices in square meters',
                'outside_terrain' => 'Outside Terrain',
                'outside_tooltip' => 'Exterior spaces such as courtyards, maneuvering areas and parking lots in square meters',
                'total_site' => 'Footprint Total Site',
                'total_site_tooltip' => 'Total land area that the project will occupy, including buildings and exteriors',
                'land_price' => 'Purchase Price Land',
                'land_price_tooltip' => 'Estimated cost of land acquisition in Mexican pesos per square meter',
            ],
            'step2' => [
                'title' => '2. Warehouse Characteristics',
                'step_indicator' => 'Step 2 of 4',
                'clear_height' => 'Clear storage height area',
                'clear_height_tooltip' => 'Available height from floor to ceiling for storage in meters',
                'loading_docks' => 'Number of loading docks',
                'loading_docks_tooltip' => 'Number of docks or loading platforms for trucks',
                'loading_doors' => 'Number of loading doors',
                'loading_doors_tooltip' => 'Number of doors for loading and unloading goods',
                'floor_capacity' => 'Max. floor load capacity',
                'floor_capacity_tooltip' => 'Maximum weight the floor can support per square meter in tons',
                'mezanine_capacity' => 'Max floor capacity mezzanine area',
                'mezanine_capacity_tooltip' => 'Maximum weight the mezzanine can support per square meter in tons',
                'foundation_required' => 'Foundation required',
                'foundation_tooltip' => 'Check this box if your project requires new foundation construction',
                'fire_walls' => 'Fire walls and doors',
                'fire_walls_tooltip' => 'Fire safety elements to contain fire',
            ],
            'step3' => [
                'title' => '3. Services',
                'step_indicator' => 'Step 3 of 4',
                'climate_control' => 'Climate control',
                'climate_tooltip' => 'Temperature and ventilation control system for the building',
                'security_gate' => 'Security gate',
                'security_gate_tooltip' => 'Controlled access system for the main entrance of the complex',
                'fire_protection' => 'Fire protection - sprinklers',
                'fire_protection_tooltip' => 'Automatic sprinkler system for fire protection',
                'security_fence' => 'Security fence',
                'security_fence_tooltip' => 'Perimeter fencing for protection and delimitation of the project area',
                'burglar_alarm' => 'Burglar alarm',
                'burglar_alarm_tooltip' => 'Detection and alarm system to prevent intrusions',
                'office_setting' => 'Office setting',
                'office_setting_tooltip' => 'Level of equipment and finishes for office areas',
            ],
            'step4' => [
                'ready_title' => 'Your parametric budget is ready!',
                'share_data' => 'Share your information so we can send it to you by email.',
                'privacy_note' => 'All your information is protected under our privacy and confidentiality policy.',
                'title' => '4. Contact Information',
                'step_indicator' => 'Step 4 of 4',
                'full_name' => 'Name',
                'full_name_tooltip' => 'Enter your full name as it appears on official documents',
                'email' => 'Email',
                'email_tooltip' => 'Valid email address where you will receive the quote',
                'phone' => 'Phone',
                'phone_tooltip' => 'Phone number for direct contact about the project',
                'company' => 'Company',
                'company_tooltip' => 'Name of the company or organization for which the project will be carried out',
                'linkedin' => 'LinkedIn (optional)',
                'linkedin_tooltip' => 'Your LinkedIn profile to establish professional connections',
                'country' => 'Country',
                'country_tooltip' => 'Country where the construction project will be developed',
                'location' => 'Location',
                'location_tooltip' => 'Specific city or region where the project will be located',
            ],
            'buttons' => [
                'next' => 'Next',
                'submit' => 'Send My Quote',
            ],
            'validation' => [
                'storage_space' => 'Please enter the storage space.',
                'production_space' => 'Please enter the production space.',
                'mezanine' => 'Please enter the mezzanine area.',
                'warehouse' => 'Please enter the warehouse area.',
                'office' => 'Please enter the office space.',
                'outside' => 'Please enter the exterior area.',
                'total_site' => 'Please enter the total plant area.',
                'land_price' => 'Enter the land purchase price.',
                'clear_height' => 'Please enter the clear storage height area.',
                'loading_docks' => 'Please enter the number of loading docks.',
                'loading_doors' => 'Enter the number of loading doors.',
                'floor_capacity' => 'Enter the maximum floor load capacity.',
                'mezanine_capacity' => 'Please enter the maximum mezzanine area load capacity.',
                'climate_control' => 'Please select the climate control option.',
                'security_gate' => 'Please enter the security gate.',
                'fire_protection' => 'Please select the fire protection option.',
                'security_fence' => 'Please enter the security fence.',
                'burglar_alarm' => 'Please enter the burglar alarm.',
                'office_setting' => 'Please select the office environment.',
                'name' => 'Please enter your name.',
                'email_valid' => 'Enter a valid email address.',
                'phone' => 'Please enter your phone number.',
                'company' => 'Enter your company name.',
                'country' => 'Please enter your country.',
                'location' => 'Please enter your location.',
            ],
            'options' => [
                'select' => 'Select',
                'hvac' => 'HVAC',
                'swamp_coolers' => 'SWAMP coolers',
                'no_ac' => 'No Air Conditioning',
                'nfpa' => 'NFPA',
                'fm' => 'FM',
                'basic' => 'Basic',
                'equipped' => 'Equipped',
                'premium' => 'Premium',
            ],
            'placeholders' => [
                'storage_space' => '500 - 1000',
                'production_space' => '300 - 600',
                'mezanine' => '150 - 300',
                'warehouse' => '1000 - 2000',
                'office' => '100 - 200',
                'outside' => '200 - 500',
                'total_site' => '1200 - 2500',
                'land_price' => '50-150',
                'clear_height' => '11 - 12',
                'loading_docks' => '4',
                'loading_doors' => '8 - 24 doors',
                'floor_capacity' => '5',
                'mezanine_capacity' => '250 - 500',
                'security_gate' => 'Automated sliding gate',
                'security_fence' => '3-meter perimeter fence',
                'burglar_alarm' => 'Alarm with motion sensors',
                'name' => 'e.g.: John Smith',
                'email' => 'e.g.: john.smith@example.com',
                'phone' => 'e.g.: 5551234567',
                'company' => 'e.g.: Acme Inc.',
                'linkedin' => 'e.g.: john-smith',
                'country' => 'e.g.: Mexico',
                'location' => 'e.g.: Mexico City',
            ],
        ],
    ],
    'recruitment' => [
        'hero' => [
            'title' => 'Join our team',
            'subtitle' => 'We are looking for talent like yours.',
            'description' => 'Your next professional challenge starts here. Discover our openings!',
        ],
        'jobs' => [
            'section_title' => 'RECRUITMENT',
            'title' => 'Job opportunities',
            'description' => 'At M2M we don\'t just manage projects - we create 
            opportunities to grow, innovate and generate impact. 
            Explore our current openings or send your CV to:',
            'looking_for' => 'We are looking for specialists in:',
            'specialties' => [
                'project_management' => 'Project Management',
                'project_scheduling' => 'Project Scheduling',
                'bim' => 'BIM',
                'architecture' => 'Architecture',
                'structural_engineering' => 'Structural Engineering',
                'civil_engineering' => 'Civil Engineering',
                'technical_drawing' => 'Technical Drawing',
                'electrical_engineering' => 'Electrical Engineering',
                'document_control' => 'Document Control',
                'hvac_systems' => 'HVAC Systems',
                'instrumentation' => 'Instrumentation',
                'process_engineering' => 'Process Engineering',
                'fire_protection' => 'Fire Protection',
                'telecommunications' => 'Telecommunications',
                'cost_integration' => 'Cost Integration',
            ],
        ],
        'internships' => [
            'section_title' => 'RECRUITMENT',
            'title' => 'Professional internships',
            'question' => 'Are you a student or recent graduate looking to start 
            your career in a dynamic and challenging environment?',
            'offer' => 'At M2M we offer you the opportunity to integrate into 
            real projects, learn from experts and develop your skills 
            in engineering and project management.',
            'call_to_action' => 'Join our team and build the future with us. Send your CV to:',
        ],
    ],
    'services' => [
        'common' => [
            'service_label' => 'SERVICE',
        ],
        'construction_agreement' => [
            'title' => 'Construction control agreement',
            'section_title' => 'Construction contracts',
            'description1' => 'To protect the interests of our clients, the M2M team has an established procedure in which we describe in a simple way the documents that we routinely recommend, included as part of this critical procedure.',
            'description2' => 'It is essential to ensure that General Contractors and their subcontractors involved in the bidding understand and comply with the legal requirements that must be considered within the legal framework of the project, such as advance payment, performance bonds, hidden defect bonds, liability insurance and retention of the guarantee fund.',
            'process_intro' => 'At this stage, M2M will have provided comprehensive details to enable our clients to make impartial recommendations to our clients. We will carry out the following:',
            'services' => [
                'letter_of_intent' => 'Assist with the Letter of Intent for Coordination of selected General Contractors.',
                'contractor_coordination' => 'Contractor Coordination.',
                'legal_agreement' => 'Assistance and coordination of the Legal Construction Agreement.',
                'contract_consolidation' => 'Consolidation of contract documents.',
                'performance_bond' => 'Performance Bond coordination.',
                'liability_insurance' => 'Civil Liability Insurance coordination.',
                'submission_control' => 'Submission authorization process control.',
                'payment_request' => 'Payment request and payment expense schedule.',
            ],
        ],
        'project_closure' => [
            'title' => 'Project closure',
            'section_title' => 'Project completion',
            'description' => 'M2M\'s Project Closure Consulting Methodology defines the excellent outcome of project investment; good Project Closure ensures our clients\' profitability and the highest quality standards to ensure achievement of project objectives, deadlines, commitments and contractual obligations.',
            'process_description' => 'After a long construction process, the M2M Project Manager ensures that the General Contractor complies with the resolution of construction details and the formal delivery of all project information.',
            'closure_description' => 'Financial and administrative closure will be completed in an orderly manner following the guidelines and regulations of the construction contract.',
        ],
        'construction_guidelines' => [
            'title' => 'General construction guidelines',
            'section_title' => 'Quality Assurance',
            'description' => 'Quality Assurance focuses on defect prevention unlike quality control which focuses on defect detection once the item is finished or built, construction or production management methods focus on ensuring that quality is integrated into the production system itself as described below:',
            'points' => [
                'evolution' => 'Evolution of quality assurance from quality control',
                'standards' => 'Quality assurance standards',
                'development' => 'Development and implementation of a quality assurance system',
            ],
        ],
        'due_diligence' => [
            'title' => 'Due diligence (site selection)',
            'section_title' => 'Due diligence site selection process',
            'description1' => 'Assist in any due diligence property site evaluation, coordinate and conduct conversations with government agencies, industrial developers to understand and confirm required land use zoning process for the specific municipality, assist client in informing project stakeholders as requested.',
            'description2' => 'Assist client in obtaining zoning variance, land use and/or other necessary plan authorizations through supervision and coordination of project team in preparation and submission of applications and presentations to area residents and municipal boards.',
            'cost_advice' => 'Advise on potential costs related to site considerations and selection, including existing topography, utility availability and/or relocation, soil conditions and parking requirements',
            'services' => [
                'economic_analysis' => 'Assist client in conducting and/or reviewing economic analysis of project(s), including basic cost, leasing, financing, disposal, not including tax impact assumptions. Comparative matrix of land cost alternatives.',
                'easements' => 'Assistance in identifying and incorporating necessary easements and covenants.',
                'risk_management' => 'Assistance in loss prevention oversight and risk management.',
                'permits_process' => 'Assistance in permitting process/streamlining recommendations.',
                'environmental_impact' => 'Assistance in phase one, environmental impact, remediation study, environmental compliance for construction (EIA) and application process.',
                'electrical_feasibility' => 'Assistance in electrical feasibility assessment with CFE property rights and KVA by third party dispatchers.',
                'hydrological_studies' => 'Assist with hydrological analysis study, geological conditions soil testing, survey, parcel registry, topographic map and dimensional control, by 3rd party consultants and site preparation.',
                'utilities_infrastructure' => 'Organize site utilities infrastructure investigation by others as needed to support the project, assist in domestic water, sewer, natural gas, fiber optic, fire protection system connections.',
                'schedule_control' => 'Project schedule assistance and control.',
            ],
        ],
        'cost_management' => [
            'title' => 'Cost management',
            'section_title' => 'Value release throughout the project',
            'description1' => 'Our quantity surveyors are dedicated to maintaining financial control and unlocking value through process validation, funding approval process, proper accounting, detailed documentation and financial reporting.',
            'description2' => 'We have the necessary tools to develop and simulate different construction cost alternatives and generate preliminary budgets to determine construction costs, IT capital improvements and extensions, defending the approximate investment needed for our clients\' projects.',
            'description3' => 'We have the tools to develop Construction Alternatives Simulation of different costs and generate Preliminary Budgets to determine Construction Costs, IT\'s capital improvements and extensions, defining the approximate amount of investment required for our clients\' projects.',
            'benefits1' => 'Key results include an accurate budget definition to generate an adequate construction cost financial plan, defining the right amount of money that needs to be invested in your projects to generate a high level of customer satisfaction',
            'benefits2' => 'Cost management generates significant savings during the generation of the construction bidding process with general contractors, which is a great advantage for our clients.',
        ],
        'engineering' => [
            'title' => 'Engineering',
            'hero_subtitle' => 'We design precise and efficient technical solutions for every stage of your project.',
            'section_title' => 'Engineering services',
            'description' => 'We develop conceptual, basic and detailed engineering for core & shell and critical and support systems in any type of industrial facility.',
            'services' => [
                'conceptual' => 'Conceptual engineering',
                'technical_representation' => 'Technical Representation and Assistance',
                'bim_integration' => 'BIM Model Integration',
                'third_party_design' => 'Third party design review',
            ],
            'delivery_phases' => 'Our delivery phases include:',
            'phases' => [
                'preconstruction' => 'Pre-construction',
                'engineering' => 'Engineering',
                'procurement' => 'Procurement',
                'construction' => 'Construction',
                'maintenance' => 'Maintenance',
            ],
        ],
        'construction_permits_page' => [
            'title' => 'Construction permits',
            'section_title' => 'Construction permit processing',
            'help_text' => 'We help you simplify the permit obtaining process',
            'description' => 'Obtaining Construction Permits in Mexico is a bureaucratic activity that takes time and can be costly. Our Project Managers will obtain permits within timely execution, following Global Ethics compliance policies, rigorous codes and ethical standards that must be followed. Through M2M\'s, we transfer responsibility to General Contractors assigned to the project and professional dispatchers to ensure it is done correctly to ensure obtaining feasibility with Local, State and Federal authorities and public service providers.',
        ],
        'more_services' => [
            'title' => 'More services',
            'services_list' => [
                'due_diligence' => 'Due diligence (site selection)',
                'cost_management' => 'Cost management',
                'engineering_planning' => 'Engineering design and planning',
                'construction_permits' => 'Construction permit process',
                'bidding_process' => 'Procurement bidding process',
                'construction_agreement' => 'Construction control agreement',
                'construction_guidelines' => 'Construction guidelines',
                'health_safety' => 'Health and safety guidelines',
                'project_closure' => 'Project closure',
            ],
        ],
        'engineering_planning' => [
            'title' => 'Engineering planning',
            'section_title' => 'Technical design & Strategic planning',
            'description1' => 'A detailed project plan is nothing more than a list of tasks and activities that must be performed to reach a milestone or produce a deliverable.',
            'description2' => 'While the project charter is created at the macro level, detailed project plans are at the micro level and function as a work plan for each team member.',
            'description3' => 'The Project Manager works with the project team to create the technical and engineering design, task list, resource plan, communications plan, budget and initial project schedule, and establishes the roles and responsibilities of the project team and stakeholders.',
        ],
        'bidding_process_page' => [
            'title' => 'Procurement bidding process',
            'section_title' => 'Value release throughout the project',
            'subtitle' => 'Contracting and bidding process - We make it easy for you to select the right contractor for your project',
            'description' => 'The location of your facilities matters now more than ever. M2M will help you identify the best contractors and subcontractors by applying a rigorous selection process to determine the best talent. We consider it equally necessary to understand the values and approach of the potential supplier to recommend a supplier that aligns with your values.',
            'selection_process_intro' => 'Our detailed selection process for each supplier includes',
            'selection_items' => [
                'technical_evaluation' => 'Evaluate and verify a supplier\'s technical capacity, commercial viability, financial soundness and solvency, and legal qualification.',
                'facility_visits' => 'Organization of facility visits',
                'bidder_preselection' => 'Bidder preselection',
                'proposal_preparation' => 'Preparation, submission and response to request for proposals.',
            ],
            'process_benefits' => 'Our process is designed to be simple and save you time and money by selecting a contractor that fits your values and has the credentials needed to carry out the work to a high standard of quality.',
        ],
        'project_management_page' => [
            'title' => 'Construction Project Management',
            'hero_subtitle' => 'We direct and supervise every phase of construction.',
            'main_title' => 'At M2M we manage construction projects from start to finish.',
            'description' => 'We coordinate teams, optimize resources and supervise every detail to ensure that your work meets the highest quality standards, is delivered on time and stays within budget.',
        ],
        'health_safety_page' => [
            'title' => 'Health and safety guidelines',
            'section_title' => 'Improve safety with clear guidelines',
            'description1' => 'Keeping health and safety procedures up to date in the construction process is another important task that M2M Project Managers perform daily on behalf of our clients.',
            'description2' => 'There are always probabilities of accidents in construction, our goal is to avoid them and encourage contractors to comply with the obligations established by law in relation to Civil Protection and Social Security Laws, the Federal Labor Law and the Ministry of Labor and Social Welfare.',
            'description3' => 'The M2M\'s way Health and Safety playbook has been developed as part of the experience in the construction of a large number of projects, it will serve as a guide during the construction process, the H&S Project Manager will methodically and routinely review that Contractors carry out daily safety courses and inspections of safety and hygiene protocols, each worker must sign the attendance and training lists for these courses.',
        ],
    ],
    'modals' => [
        'content_title' => 'Playbook content:',
        'index' => 'Index',
        'subjects' => 'Subjects:',
        'project_management' => [
            'title' => 'Introduction to Project Management',
            'description1' => 'The specialized Due Diligence and Site Selection service is acquiring growing relevance in the most important projects worldwide.',
            'description2' => 'A comprehensive analysis of legal, environmental, hydrological and geological characteristics, as well as local services and infrastructure, provides crucial information for informed decision-making in our clients\' investments.',
            'content' => [
                'site_selection_guide' => 'Site Selection Guide',
                'introduction' => 'Introduction',
                'site_selection_process' => 'Site Selection Process',
                'macro_location' => 'Macro Location',
                'micro_location' => 'Micro Location',
                'key_factors' => 'Key Factors in Site Selection',
                'methodology' => 'Site Selection Methodology',
                'conclusion' => 'Conclusion',
                'due_diligence_methodology' => 'Methodology for Due Diligence Property Evaluation',
            ],
        ],
        'strategic_leadership' => [
            'title' => 'Strategic Leadership',
            'description1' => 'Leadership in construction projects is a balance between art and science. Science involves the application of methodologies, tools, metrics and best practices to plan, control and manage risks. Art lies in the leader\'s ability to influence, motivate, communicate and manage human relationships, removing barriers and aligning the interests of all stakeholders.',
            'description2' => 'The Project Manager (PM) must develop tools to lead work teams, reduce risks and achieve project success, effectively managing communication, lessons learned and key indicators of earned value, cost, time and scope.',
        ],
        'quality_management' => [
            'title' => 'Quality Management',
            'description1' => 'Management plans, procedure control and quality assurance.',
            'content' => [
                'preliminary_studies' => 'Preliminary Studies',
                'earthworks' => 'Earthworks',
                'foundations' => 'Foundations',
                'rainwater_design' => 'Rainwater Design',
                'metal_structure' => 'Metal Structure',
                'concrete_floors' => 'Concrete Floors',
                'tilt_up_walls' => 'Tilt Up Walls',
                'civil_works' => 'Civil Works',
                'plumbing' => 'Plumbing',
                'electrical_system' => 'Electrical System',
                'air_conditioning_systems' => 'Air Conditioning Systems',
                'fire_systems' => 'Fire Systems',
                'special_systems' => 'Special Systems',
                'pavements' => 'Pavements',
                'exterior_works' => 'Exterior Works',
            ],
        ],
        'safety_hygiene' => [
            'title' => 'Safety & Hygiene',
            'description1' => 'The profession of Safety and Hygiene Supervisor requires extensive knowledge of regulations and much discipline. Every day hundreds of processes are carried out simultaneously in different specialties, safety work is the responsibility of all members working in construction.',
            'description2' => 'The Project Manager must have the ability to recognize safety and hygiene priorities and at the same time must have well-defined correct safety protocols and procedures, assuming leadership from planning during construction and until the total closure of the work.',
            'content' => [
                'safety_manual' => 'Safety and Hygiene Manual',
                'safety_health_system' => 'Safety and Health System on Site',
                'safety_regulations' => 'Safety Regulations',
                'golden_rules' => 'Golden Rules of Safety',
                'osha_methodology' => 'OSHA Safety Methodology',
                'work_stoppage_policy' => 'Work Stoppage Policy',
                'safety_health_policy' => 'Safety and Health Policy',
                'environmental_policy' => 'Environmental Policy',
                'contingency_procedure' => 'Contingency Procedure',
                'hazardous_waste_control' => 'Hazardous Waste Control',
                'site_cleanliness' => 'Site Cleanliness and Hygiene',
                'fatality_report' => 'Fatality Report',
            ],
        ],
        'procurement' => [
            'title' => 'Procurement',
            'description1' => 'The fundamental purpose is to exercise control over the rules of the project, establish a common and clear objective, help the efforts of the participants to create more and better projects that translate into growth opportunities, so that the project can be strong and develop in harmony and generate prosperity.',
            'content' => [
                'project_execution' => 'Project plan execution.',
                'construction_bidding_strategy' => 'Construction bidding strategy and processes.',
                'project_scheduling' => 'Project time scheduling.',
                'parametric_costs' => 'Parametric costs.',
                'contractor_evaluation' => 'General contractor evaluation.',
                'supplier_code' => 'Supplier code of conduct.',
                'rfp_methodology' => 'Methodology for developing an executive project design RFP.',
                'drawings_index' => 'Drawings index.',
                'engineering_control' => 'Methodology for controlling and reviewing executive project engineering progress.',
                'change_control' => 'Change control in industrial projects.',
                'candiles_case_study' => 'Case study: Candiles shopping center repositioning.',
                'codes_compliance' => 'Compliance with construction norms and codes.',
                'construction_bidding' => 'Construction bidding and RFP development.',
                'five_rounds_technique' => '5 rounds technique – value to fee.',
                'savings_management' => 'Savings opportunity management.',
                'feedback_methodology' => 'Feedback and communication methodology.',
                'schedule_of_values' => 'Schedule of values (concept catalog).',
                'value_engineering' => 'Value engineering.',
                'pm_improvements' => 'Project management methodology improvements in industrial bidding.',
                'contractor_selection' => 'General contractor selection.',
                'lessons_learned' => 'Feedback, lessons learned and audits in construction bidding.'
            ],
        ],
        'land_development' => [
            'title' => 'Land Development',
            'description1' => 'Industrial parks are engines of employment, innovation and regional development, capable of transforming communities when planned with precision and efficiency. With more than 75 years of combined experience in industrial real estate in Mexico, our team integrates urbanism, infrastructure, sustainability, regulations and strategy, applying certified methodologies from the Project Management Institute to guarantee profitable, sustainable projects with high economic and social impact.',
            'description2' => 'Introduction to industrial park methodology.',
            'content' => [
                'planning_process' => 'Project planning process and life cycle.',
                'requirements_analysis' => 'Requirements analysis.',
                'engineering_development' => 'Engineering development.',
                'cost_time_management' => 'Cost and time management.',
                'parameters_definition' => 'Parameters definition.',
                'project_charter' => 'Project Charter.',
                'legal_permits' => 'Legal framework and permits.',
                'urban_regulations' => 'Urban, environmental and fiscal regulations.',
                'ejidal_lands' => 'Full domain over ejidal parcels.',
                'land_use_permit' => 'Land use permit.',
                'mexican_standards' => 'Mexican Industrial Parks Standards and certifications.',
                'architectural_design' => 'Architectural and urban design.',
                'financial_analysis' => 'Financial analysis of real estate investments.',
                'feasibility_study' => 'Feasibility study and break-even point.',
                'roi_valuation' => 'Return on investment (ROI) and valuation.',
                'industrial_leasing' => 'Industrial leasing.',
                'preliminary_studies' => 'Preliminary studies and construction permits.',
                'location_studies' => 'Location, soil mechanics, environmental and hydrological impact.',
                'utilities_feasibility' => 'Feasibilities (electrical, water, drainage, gas, access).',
                'urbanization_costs' => 'Urbanization and infrastructure cost analysis.',
                'technical_regulations' => 'Technical and construction regulations.',
                'general_provisions' => 'General provisions.',
                'design_committee' => 'Technical design and construction committee.',
                'hydraulic_infrastructure' => 'Hydraulic and private infrastructure.',
                'project_construction_operation' => 'Project, construction and operation.',
                'innovative_trends' => 'Innovative trends and commercial strategy.',
                'additional_services' => 'Additional services and private hubs.',
                'conclusions' => 'Conclusions.'
            ],
        ],
        'strategic_planning' => [
            'title' => 'Strategic Planning',
            'description1' => 'The Strategic Planning methodology describes the management processes and tools to initiate the project, ensuring compliance with objectives during the project life cycle.',
            'description2' => 'At this stage, strategic planning is implemented by implementing the Project Management Plan, defining the baseline cost, scope and time.',
            'description3' => 'The Project Charter is signed, management plans are established for: scope, time, costs, quality, risks, communication and procurement.',
            'content' => [
                'project_initiation' => 'Project initiation and planning',
                'project_sponsor' => 'The project sponsor',
                'objectives_vs_goals' => 'Project objectives vs. project goals',
                'objectives_benefits' => 'The benefits of project objectives',
                'project_lifecycle' => 'Project life cycle',
                'planning_stage' => 'Project planning stage',
                'initiation_processes' => 'Project initiation and planning processes',
                'project_charter' => 'Project Charter',
                'project_direction_plan' => 'Project management plan',
                'scope_management' => 'Scope management',
                'time_management' => 'Time management',
                'cost_management' => 'Cost management',
                'quality_management' => 'Project quality management',
                'human_resources_management' => 'Human resources management',
                'communications_management' => 'Project communications management',
                'risk_management' => 'Project risk management',
                'procurement_management' => 'Project procurement management',
                'final_deliverables' => 'Final deliverables that will comprise the project result',
                'scope_creep_what' => 'What is scope creep and how can you avoid it?',
                'scope_creep_why' => 'Why does it happen?',
                'scope_creep_how' => 'How can we solve the problem?',
                'change_management_what' => 'Change Management – What is it and what is it for?',
                'change_management_service' => 'Change Management – Consulting service',
                'change_management_factors' => 'Change Management – Key process factors',
                'escalation_matrix' => 'Escalation matrix of roles and responsibilities',
                'change_leadership_training' => 'Training and leadership towards change',
            ],
        ],
        'construction_permits' => [
            'title' => 'Construction Permits',
            'description1' => 'Construction permit procedures are becoming increasingly elaborate. Through this Playbook you will find a guide to prevent setbacks when starting construction, and the responsibility of the D.R.O, contracting procedures for feasibility studies for electrical, water and drainage service connections for your new projects.',
            'description2' => 'We focus on the sustainability of environmental impact, traffic impact, Civil Protection requirements for the safety of project users.',
            'description3' => 'We prevent setbacks in the operating license, avoiding risks with structural co-responsible parties, closures or fines with IMSS, ensuring we have no impacts during construction execution.',
            'content' => [
                'introduction' => 'Introduction to construction permits',
                'permits_list' => 'List of permits and applicable regulations',
                'specialized_managers' => 'Specialized managers and ethical compliance',
                'requirements_procedures' => 'Requirements and procedures for construction permits',
                'compliance_importance' => 'Importance of regulatory compliance',
                'definitive_permit' => 'Definitive construction permit',
                'land_use_coefficients' => 'Land use and coefficients (CUS, COS)',
                'director_responsibilities' => 'Responsibilities of the responsible construction director and co-responsible parties',
                'urban_development_review' => 'Project review by urban development',
                'civil_protection_approval' => 'Civil protection approval',
                'work_suspension' => 'Work suspension',
                'traffic_impact' => 'Traffic impact (feasibility, study, mitigation)',
                'environmental_impact' => 'Environmental impact (manifest, resolution, case studies)',
                'services_connection' => 'Services connection: water, drainage and electrical energy',
                'imss_obligations' => 'Legal and regulatory obligations of IMSS in construction projects',
                'civil_protection_permits' => 'Civil protection permits and processes',
                'work_completion_procedure' => 'Work completion procedure',
            ],
        ],
        'construction_contract' => [
            'title' => 'Construction Contract',
            'description1' => 'The correct implementation of the construction contract strategy is a powerful tool, it clearly and precisely defines the project objectives, provides important control rules and dramatically accelerates project development, creating benefits that contribute to project success.',
            'description2' => 'M2M implements professional strategies, contributing and adding value in this collection of activities.',
            'content' => [
                'contract_annexes_checklist' => 'Contract annexes checklist',
                'lump_sum_contract' => 'Lump sum contract',
                'guaranteed_maximum_price' => 'Guaranteed maximum price contract',
                'cost_plus_fee' => 'Cost plus fee contract',
                'unit_price_contract' => 'Unit price contract',
                'letter_of_intent' => 'Letter of intent',
                'advance_invoice' => 'Advance invoice',
                'bonds' => 'Bonds',
                'liability_insurance' => 'Liability insurance',
                'submittal_authorization_format' => 'Submittal authorization format',
                'submittal_authorization_procedure' => 'Submittal authorization procedure',
                'park_internal_regulations' => 'Park internal regulations',
                'industrial_safety_regulations' => 'Industrial safety and hygiene regulations',
                'imss_contractor_registration' => 'IMSS contractor registration',
                'sat_registration_rfc' => 'SAT registration and RFC copy of contractor',
                'technical_deliverables_index' => 'Index of technical deliverables and warranties',
                'work_organization_chart' => 'Work organization chart, communication lines, roles and responsibilities matrix',
                'guarantee_fund_retention' => 'Guarantee fund retention notice',
                'monthly_progress_estimate' => 'Monthly progress estimate format',
                'weekly_report_format' => 'Weekly report format',
                'change_order_format' => 'Change order format',
                'effective_change_procedure' => 'Effective change order procedure',
                'beneficial_area_delivery' => 'Beneficial area delivery/reception act',
                'substantial_area_delivery' => 'Substantial area delivery/reception act',
                'punch_list_format' => 'Punch list details format',
                'supplier_payment_letter' => 'Supplier payment letter and liability settlement format',
                'final_delivery_folders' => 'Final delivery folders index',
                'final_delivery_reception' => 'Final delivery/reception act',
            ],
        ],
        'closing_stage' => [
            'title' => 'Project Closing',
            'description1' => 'The closing stage in a construction project involves the completion of all activities, the delivery of results to the client, the evaluation of project performance and the dissolution of the project team.',
            'description2' => 'It is a critical phase that marks the successful end of the project and provides an opportunity to reflect on achievements and lessons learned throughout the entire project life cycle.',
            'content' => [
                'why_important' => 'Why is project closure so important?',
                'clear_next_steps' => 'Clearly indicates the next steps.',
                'capture_lessons' => 'Capture lessons learned.',
                'confirm_work_finished' => 'Confirm that the work is finished.',
                'how_know_finished' => 'How do you know when a project is really finished?',
                'close_in_8_steps' => 'How to close a project in 8 steps.',
                'administration_procedures' => 'Administration and supervision procedures in project closure.',
                'work_termination' => 'Work termination or closure.',
                'punch_list' => 'Punch List pending items.',
                'release_of_liens' => 'No debt letters to suppliers "Release of Liens".',
                'work_reception_acts' => 'Work reception acts.',
                'beneficial_delivery_act' => 'Beneficial delivery act.',
                'substantial_delivery_act' => 'Substantial delivery act.',
                'final_delivery_act' => 'Final delivery act.',
                'commissioning_protocol' => 'Commissioning test protocol.',
                'imss_no_debt_letter' => 'No debt letter from IMSS SIROC (Social Security Work Registry).',
                'as_built_delivery' => 'Delivery and review of As-Built drawings and manuals and warranties.',
                'hidden_defects_bond' => 'Hidden defects bond.',
                'work_completion' => 'Work completion.',
                'improper_completion' => 'Improper work completion.',
                'final_report' => 'Final report.'
            ],
        ],
        'project_design' => [
            'title' => 'Project Design',
            'description1' => 'Master Plan Design Execution Methodology.',
            'description2' => 'The correct implementation of engineering development control depends on a strategic plan, execution demands control and monitoring, reduces risks, provides good results and savings for clients.',
            'content' => [
                'objective_distinction' => 'Objective, Distinction and Who We Are.',
                'client_value_management' => 'Client Value and Collaborative Management.',
                'm2m_pdb_consulting' => 'M2M PDB Consulting (Program Development and Building).',
                'design_execution_process' => 'Project Design Execution Process.',
                'master_plan_implementation' => 'Master Plan Implementation and Follow-up.',
                'control_dashboards' => 'Control Dashboards and Information Control (Power BI).',
                'bim_modeling' => 'BIM LOD 200 Modeling and Navisworks Control.',
                'lean_construction_strategy' => 'Contracting Strategy and Lean Construction Support.',
                'objectives_alignment' => 'Objectives Alignment Methodology.',
                'project_plan_execution' => 'Project Plan Execution.',
                'scope_definition_control' => 'Scope Definition and Control.',
                'performance_monitoring' => 'Performance Monitoring and Earned Value Techniques (EVM).',
                'design_management_software' => 'Software Tools for Design Management.',
                'agile_lean_methodologies' => 'Application of Agile and Lean Construction Methodologies.',
                'stakeholder_communication' => 'Effective Communication and Stakeholder Management.',
                'quality_control_risks' => 'Quality Control and Risk Identification.',
                'space_planning_analysis' => 'Space Planning and Analysis / Preliminary Project.',
                'supplier_code_rfps' => 'Supplier Code of Conduct and RFPs.',
                'drawings_index_control' => 'Drawings Index and Progress Control.',
                'change_control_compliance' => 'Change Control, Traceability Matrix and Regulatory Compliance.',
                'technical_financial_requirements' => 'Technical and Financial Requirements.',
                'schedule_of_values_catalog' => 'Concept Catalog – Schedule of Values.'
            ],
        ],
        'data_center' => [
            'title' => 'Data Center',
            'description1' => 'We live in an era marked by global interconnectivity, where Data Centers are the invisible engine that enables the constant flow of information, supporting everything from teleworking and distance education to innovations in smart cities and autonomous vehicles. The pandemic accelerated this transformation, confirming that these infrastructures are essential pillars of modern life and the digital future.',
            'description2' => 'With experience in projects of national and international scope, our team of Project Managers has participated in developments ranging from technology centers for multinationals to intelligent lighting solutions. This manual seeks not only to highlight the strategic importance of Data Centers, but also to inspire those who wish to be an active part of this technological revolution.',
            'content' => [
                'digital_revolution' => 'The Digital Age Revolution and its Dependence on Data Centers.',
                'mexico_background' => 'Background and Evolution in Mexico.',
                'digital_gap' => 'Opportunities and Digital Gap.',
                'intelligent_networks' => 'Data Centers and Intelligent Networks ("Human Networks").',
                'data_center_types' => 'Data Center Types and Components.',
                'costs_standards_tiers' => 'Costs, Standards and Tiers.',
                'development_infrastructure' => 'Development and Infrastructure.',
                'location_electrical_analysis' => 'Location and Electrical Network Analysis.',
                'architectural_design' => 'Architectural Design and Spaces.',
                'redundancy_efficiency' => 'Redundancy and Energy Efficiency.',
                'speed_storage_mmr' => 'Speed, Storage and MMR.',
                'studies_planning' => 'Studies and Planning.',
                'needs_evaluation' => 'Needs Assessment.',
                'financial_viability' => 'Financial Viability.',
                'electrical_cooling_design' => 'Electrical, Cooling, Network and Security Design.',
                'risk_management' => 'Risk Management and Regulatory Compliance.',
                'permits_land_acquisition' => 'Permits and Land Acquisition.',
                'fire_systems_latency' => 'Fire Systems and Latency.',
                'industrial_parks_maintenance' => 'Industrial Parks, Infrastructure and Maintenance.',
                'costs_leasing_roi' => 'Costs, Leasing and ROI.',
                'conclusion' => 'Conclusion.'
            ],
        ],
        'cost_management' => [
            'title' => 'Cost Management',
            'description1' => 'Proper financial planning, administration and control of the cost baseline in projects is one of the three priorities of Project Managers.',
            'description2' => 'The Cost Control Methodology provides important tools to predetermine parametric construction costs of different types of building projects, which allow us to manage the capital investment and equipment approval process, we provide fair market values for foreign investments.',
            'content' => [
                'cost_administration_intro' => 'Introduction to cost administration.',
                'project_direction_plan' => 'Project direction plan.',
                'cost_management_planning' => 'Cost management and planning.',
                'parametric_budget' => 'Parametric budget.',
                'industrial_building_classification' => 'Industrial building classification.',
                'speculative_building_classes' => 'Speculative building and industrial warehouse classes.',
                'engineering_control_monitoring' => 'Project engineering control and monitoring.',
                'construction_costs' => 'Construction costs.',
                'materials_labor_machinery' => 'Materials, labor and machinery.',
                'fixed_costs_consumption' => 'Fixed costs and consumption.',
                'crews_performance' => 'Crews and performance.',
                'mixtures_dosage_analysis' => 'Mixtures and dosage analysis.',
                'building_technical_questionnaire' => 'Building technical questionnaire.',
                'concepts_catalog' => 'Concepts catalog (Schedule of values).',
                'final_report_lessons' => 'Final report and lessons learned.',
                'conclusion' => 'Conclusion.'
            ],
        ],
        'control_monitoring' => [
            'title' => 'Control and Monitoring',
            'description1' => 'Project Monitoring and Control is fundamental to evaluate its current status, detect possible problems and make preventive or corrective decisions. These actions may involve adjustments to the original plan, ensuring that the project remains aligned with its objectives.',
            'description2' => 'Construction Project Managers employ specialized tools and processes to supervise and control the project, ensuring that it is completed according to the objectives established in the project management plan.',
            'description3' => 'The work breakdown structure (WBS) allows tracking, evaluating and regulating progress, performance and any necessary changes in the project, timely identifying areas that require adjustments to the plan.',
            'content' => [
                'performance_control_tools' => 'Performance control and monitoring tools.',
                'scope_requirements_management' => 'Scope, requirements and deliverables management.',
                'traceability_matrix' => 'Traceability matrix.',
                'work_breakdown_structure' => 'Work breakdown structure.',
                'change_requests' => 'Change requests.',
                'performance_reports' => 'Performance reports.',
                'time_control_monitoring' => 'Time control and monitoring.',
                'cost_control_monitoring' => 'Cost control and monitoring.',
                'quality_control_monitoring' => 'Quality control and monitoring.',
                'hr_control_monitoring' => 'Human resources control and monitoring.',
                'communications_control_monitoring' => 'Communications control and monitoring.',
                'risk_control_monitoring' => 'Risk control and monitoring.',
                'procurement_control_monitoring' => 'Procurement control and monitoring.'
            ],
        ],
        'site_selection_process' => [
            'title' => 'Site Selection Process',
            'description1' => 'The specialized Due Diligence and Site Selection service is gaining increasing relevance in the most important projects worldwide.',
            'description2' => 'An exhaustive analysis of legal, environmental, hydrological and geological characteristics, as well as local services and infrastructure, provides crucial information for informed decision-making in our clients\' investments.',
            'content' => [
                'site_selection_guide_mexico' => 'Site selection guide in Mexico.',
                'introduction' => 'Introduction.',
                'site_selection_process' => 'Site selection process.',
                'key_selection_factors' => 'Key factors in site selection.',
                'site_selection_methodology' => 'Site selection methodology.',
                'conclusion' => 'Conclusion.',
                'due_diligence_methodology' => 'Methodology for due diligence evaluation of properties.',
                'land_use_feasibility' => 'Land use feasibility.',
                'land_cost_proposals' => 'Economic land cost proposals.',
                'land_alternatives_cost_matrix' => 'Land alternatives cost matrix.',
                'technical_acquisition_study' => 'Technical land acquisition study / Due Diligence.',
                'phase_one_study' => 'Phase One study.',
                'hydrological_study' => 'Hydrological study.',
                'hydrological_importance_case' => 'Case studies: The importance of hydrological study.',
                'hydrological_process' => 'Hydrological study process.',
                'conclusion_hydro' => 'Conclusion.',
                'soil_mechanics_study' => 'Soil mechanics study.',
                'environmental_accreditation' => 'Environmental accreditation.',
                'land_purchase_contract' => 'Land purchase contract.',
                'property_evaluation_study' => 'Technical property evaluation study.',
                'building_classification_criteria' => 'Building classification criteria.',
                'negotiation_strategy' => 'Negotiation strategy for attracting industrial projects.',
                'investment_profile' => 'Investment profile.',
                'government_letter_intent' => 'Letter of intent for government.'
            ],
        ],
    ],
    'contact' => [
        'title' => 'Contact Us',
        'quote' => '"Success in construction 
        depends not only on 
        blueprints, but on the 
        passion and leadership 
        of the team."',
        'email_us' => 'Write to us at',
        'call_us' => 'or call:',
        'form_title' => 'Or leave us your details and we will contact you',
        'name' => 'Name',
        'phone' => 'Phone Number',
        'email' => 'Email',
        'send' => 'Send',
        'social_networks' => 'Find us on social networks',
    ],
    'common' => [
        'back_to_top' => 'Back to top',
        'inicio' => 'Home',
        'close' => 'Close',
        'more_info' => 'More information',
        'learn_more' => 'Learn more',
        'previous' => 'Previous',
        'next' => 'Next',
    ],
];
?>