<?php
if (empty($_POST['name']) || empty($_POST['email']) || empty($_POST['phone'])) {
    echo json_encode(['success' => false, 'message' => 'Todos los campos son requeridos']);
    exit;
}

$nombre = htmlspecialchars($_POST['name']);
$apellido = htmlspecialchars($_POST['lastName']);
$email = htmlspecialchars($_POST['email']);
$celular = htmlspecialchars($_POST['phone']);
$mensaje = nl2br(htmlspecialchars($_POST['message']));

$asunto = 'Mensaje de contacto';

$destinatario = 'contact@m2m.com.mx';
// $destinatario = 'carlos@awsoftware.mx';
$cuerpo = '
<html>
<head>
    <title>Mensaje de contacto</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border: 1px solid #dddddd;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .header {
            background-color: #008D00;
            color: #ffffff;
            text-align: center;
            padding: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 20px;
            color: #333333;
        }
        .content p {
            margin: 10px 0;
        }
        .content p span {
            font-weight: bold;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #f4f4f4;
            color: #777777;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>Mensaje de Contacto</h1>
        </div>
        <div class="content">
            <p><span>Nombre:</span> ' . $nombre . '</p>
            <p><span>Celular:</span> ' . $celular . '</p>
            <p><span>Email:</span> ' . $email . '</p>
        </div>
        <div class="footer">
            <p>Este mensaje fue enviado desde el formulario de contacto de tu sitio web.</p>
        </div>
    </div>
</body>
</html>
';

$headers = 'MIME-Version: 1.0' . "\r\n";
$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
$headers .= 'From: ' . $email . "\r\n";

try {
    if (mail($destinatario, $asunto, $cuerpo, $headers)) {
        echo json_encode(['success' => true, 'message' => 'Mensaje enviado correctamente']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al enviar el mensaje']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}
