<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dron Trc</title>
    <link rel="icon" href="img/logo.png" type="image/x-icon">

    <link rel="stylesheet" href="css/style.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous">
</head>

<body>
    <header>
        <nav class="navbar">
            <img src="img/logo.png" alt="" class="nav-logo">
            <div class="nav-div">
                <ul>
                    <li>
                        <a href="#dron">
                            DRON TRC
                        </a>
                    </li>
                    <li>
                        <a href="#servicios">
                            SERVICIOS
                        </a>
                    </li>
                    <li>
                        <a href="#proyectos">
                            PROYECTOS
                        </a>
                    </li>
                    <li>
                        <a href="#contacto" class="nav-a">
                            CONTACTO
                            <svg width="25" height="20" viewBox="0 0 18 18" style="vertical-align: middle; transform: rotate(45deg);">
                                <line x1="4" y1="9" x2="12" y2="9" stroke="#fff" stroke-width="1" stroke-linecap="round" />
                                <polyline points="9,6 12,9 9,12" fill="none" stroke="#fff" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>
    </header>

    <section class="one-section">
        <video src="videos/inicio.mp4" class="os-video" autoplay muted loop></video>
        <div class="os-div">
            <p class="os-p">LAS MEJORES TOMAS</p>
            <p class="os-p2">AÉREAS</p>
        </div>
        <img src="img/camara_interface.png" alt="" class="os-img">
    </section>

    <section class="two-section" id="dron">
        <img src="img/formas/rectangle.png" alt="" class="ts-img">
        <div class="ts-div">
            <p class="ts-p">En Dron TRC</p>

            <p class="ts-p2">Ofrecemos los mejores servicios de fotografía y video
                con dron en la región.</p>

            <p class="ts-p3">Adaptemos nuestros servicios a cualquier proyecto brindando una
                soluciones sencillas para obtener resultados de calidad en tiempo y
                forma.</p>
            <a href="" class="nav-a">
                COTIZA TU PROYECTO
                <svg width="25" height="20" viewBox="0 0 18 18" style="vertical-align: middle; transform: rotate(45deg);">
                    <line x1="4" y1="9" x2="12" y2="9" stroke="#fff" stroke-width="1" stroke-linecap="round" />
                    <polyline points="9,6 12,9 9,12" fill="none" stroke="#fff" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </a>
        </div>
        <img src="img/dron.png" alt="" class="ts-img2">
        <div class="ts-div2">
            <img src="img/iconos/proporcion.png" alt="" class="ts-img3">
            <img src="img/iconos/bateria.png" alt="" class="ts-img3">
        </div>
    </section>

    <section class="three-section" id="servicios">
        <div class="ths-div">
            <p class="ths-p">NUESTROS SERVICIOS</p>
            <p class="ths-p2">Soluciones aéreas para tu proyecto</p>
            <div class="row align-items-start">
                <div class="col-md-4">
                    <img src="img/foto.png" alt="" class="ths-img">
                </div>
                <div class="col-md-8">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="ths-div2 scroll-animate service-card">
                                <div class="ths-div3">
                                    <p class="ths-p3">FOTOGRAFÍA AÉREA</p>
                                    <hr class="ths-hr">
                                </div>
                                <p class="ths-p4">Capturamos imagenes desde el aire con precisión y claridad.
                                    Ideal para mostrar espacios, instalaciones y entornos desde una nueva perspectiva.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="ths-div2 scroll-animate service-card">
                                <div class="ths-div3">
                                    <p class="ths-p3">VIDEO AÉREO</p>
                                    <hr class="ths-hr">
                                </div>
                                <p class="ths-p4">Impresiona con tomas aéreas en alta definición. Haz que tu proyecto, evento o propiedad se vea espectacular desde el cielo.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="ths-div2 scroll-animate service-card">
                                <div class="ths-div3">
                                    <p class="ths-p3">TOMAS 360</p>
                                    <hr class="ths-hr">
                                </div>
                                <p class="ths-p4">Ofrecemos tomas envolventes que permiten recorrer y conocer cada espacio desde todos los ángulos.
                                    Una experiencia visual completa.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="ths-div2 scroll-animate service-card">
                                <div class="ths-div3">
                                    <p class="ths-p3">EDICIÓN DE VIDEO</p>
                                    <hr class="ths-hr">
                                </div>
                                <p class="ths-p4">Damos forma a tus ideas con ediciones dinámicas y de calidad profesional.
                                    Contenido visual que comunica y cautiva.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="four-section">
        <div class="fs-div">
            <div class="fs-div2 scroll-animate sector-card">
                <img src="img/industrial.png" alt="" class="fs-img">
                <p class="fs-p">01</p>
                <p class="fs-p2">SECTOR
                    <span>INDUSTRIAL</span>
                </p>
                <p class="fs-p3">Mostremos la dimensión y capacidad de
                    tu operación desde las alturas.</p>
                <p class="fs-p4">Capturamos imágenes y videos aéreos de naves industriales, plantas, procesos y proyectos de obra, ideales para supervision, documentación y promoción</p>
            </div>
            <div class="fs-div2 scroll-animate sector-card">
                <img src="img/inmobiliario.png" alt="" class="fs-img">
                <p class="fs-p">02</p>
                <p class="fs-p2">SECTOR
                    <span>INMOBILIARIO</span>
                </p>
                <p class="fs-p3">Haz que cada propiedad destaque con tomas aéreas que capturan su ubicación, tamaño y
                    entorno.</p>
                <p class="fs-p4">Imágenes ideales para promoción, preventa o presentación de desarrollos residenciales,
                    comerciales o turísticos.
                </p>
            </div>
            <div class="fs-div2 scroll-animate sector-card">
                <img src="img/educativo.png" alt="" class="fs-img">
                <p class="fs-p">03</p>
                <p class="fs-p2">SECTOR
                    <span>EDUCATIVO</span>
                </p>
                <p class="fs-p4">Muestra la infraestructura y amplitud de tu institución desde una nueva perspectiva.
                    Tomas aéreas perfectas para materiales promocionales y campañas de inscripción.</p>

            </div>
            <div class="fs-div2 scroll-animate sector-card">
                <img src="img/deportivo.png" alt="" class="fs-img">
                <p class="fs-p">04</p>
                <p class="fs-p2">SECTOR
                    <span>DEPORTIVO</span>
                </p>
                <p class="fs-p4">Captura la energía y magnitud de tus eventos deportivos o instalaciones desde el cielo.
                    Perfecto para promoción de torneos, academias o contenido para redes sociales.</p>
            </div>
        </div>
    </section>


    <div class="container" id="proyectos">
        <div class="section-title">PROYECTOS</div>
        <h1 class="main-title">Nuestro trabajo más reciente</h1>
        
        <!-- Imagen decorativa al inicio de la sección -->
        <!-- <div class="projects-header-image scroll-animate fade-up">
            <img src="img/rectangle23.png" alt="Decoración" class="header-decoration">
        </div>
        -->
        <div class="projects-grid">
            
            <?php
            // Obtener todas las imágenes de la carpeta galería
            $galeria_path = './img/galeria/';
            $imagenes = glob($galeria_path . '*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
            
            // Array con información de los proyectos (puedes personalizarlo)
            $proyectos_info = [
                ['year' => '2025', 'location' => 'Querétaro', 'name' => 'Horizon Industrial Park'],
                ['year' => '2024', 'location' => 'Ciudad de México', 'name' => 'Torre Corporativa'],
                ['year' => '2024', 'location' => 'Guadalajara', 'name' => 'Centro Comercial'],
                ['year' => '2025', 'location' => 'Monterrey', 'name' => 'Complejo Residencial'],
                ['year' => '2024', 'location' => 'Tijuana', 'name' => 'Parque Tecnológico'],
                ['year' => '2025', 'location' => 'Puebla', 'name' => 'Campus Universitario'],
                ['year' => '2024', 'location' => 'Mérida', 'name' => 'Hotel Resort'],
                ['year' => '2025', 'location' => 'León', 'name' => 'Zona Industrial'],
                ['year' => '2024', 'location' => 'Cancún', 'name' => 'Desarrollo Turístico'],
                ['year' => '2025', 'location' => 'Aguascalientes', 'name' => 'Centro Logístico'],
                ['year' => '2024', 'location' => 'Toluca', 'name' => 'Parque Empresarial'],
                ['year' => '2025', 'location' => 'Cuernavaca', 'name' => 'Residencial Premium'],
                ['year' => '2024', 'location' => 'Morelia', 'name' => 'Plaza Comercial'],
                ['year' => '2025', 'location' => 'Saltillo', 'name' => 'Complejo Industrial'],
                ['year' => '2024', 'location' => 'Chihuahua', 'name' => 'Centro de Distribución'],
                ['year' => '2025', 'location' => 'Oaxaca', 'name' => 'Proyecto Ecológico']
            ];
            
            // Generar las tarjetas de proyecto dinámicamente
            foreach ($imagenes as $index => $imagen) {
                $proyecto = $proyectos_info[$index] ?? $proyectos_info[0]; // Usar el primer proyecto como fallback
                $nombre_archivo = basename($imagen);
                $alt_text = "Proyecto " . ($index + 1);
            ?>
                <div class="project-card scroll-animate project-card-scroll">
                    <div class="project-image-wrapper">
                        <img src="<?php echo $imagen; ?>" alt="<?php echo $alt_text; ?>" class="project-image">
                    </div>
                    <div class="project-info">
                        <div class="project-meta">
                            <span class="project-year"><?php echo $proyecto['year']; ?></span>
                            <span class="project-divider">|</span>
                            <span><?php echo $proyecto['location']; ?></span>
                        </div>
                        <div class="project-location"><?php echo $proyecto['name']; ?></div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

    <!-- <section class="five-section" id="proyectos">
        <img src="img/formas/rectange2.png" alt="" class="fis-img">
        <div class="fis-div">
            <p class="fis-p">PROYECTOS</p>
            <p class="fis-p2">Nuestro trabajo más reciente</p>

            <div class="row">
                <div class="col-md-6">
                    <div class="fis-div2">
                        <p class="fis-p3">CISEF INDUSTRIAL PARK</p>
                        <hr class="fis-hr">
                    </div>
                    <p class="fis-p4">Se realizó un levantamiento visual con dron para documentar el terreno, las naves industriales
                        existentes y vialidades cercanas. Este proyecto tuvo como objetivo proporcionar una vista integral
                        del parque industrial, destacando su desarrollo, conectividad y potencial estratégico.</p>
                    <div class="fis-div3">
                        <p class="fis-btn">Video aéreo</p>
                        <p class="fis-btn">Edición de video</p>
                    </div>
                </div>
                <div class="col-md-6">
                    <img src="img/cisef.png" alt="" class="fis-img2">
                </div>

                <div class="col-md-6">
                    <div class="fis-div2">
                        <p class="fis-p3">CISEF INDUSTRIAL PARK</p>
                        <hr class="fis-hr">
                    </div>
                    <p class="fis-p4">Captura imágenes desde el aire con precisión y claridad. Ideal para mostrar espacios, instalaciones y entornos desde una nueva perspectiva.</p>
                    <div class="fis-div3">
                        <p class="fis-btn">Video aéreo</p>
                        <p class="fis-btn">Edición de video</p>
                    </div>
                </div>
                <div class="col-md-6">
                    <img src="img/cisef.png" alt="" class="fis-img2">
                </div>

            </div>
        </div>
    </section> -->

    <!-- <section class="six-section">
        <div class="ss-div">
            <img src="img/galeria/G1.png" alt="" class="ss-img">
            <div class="ss-div2">
                <img src="img/galeria/G2.png" alt="" class="ss-img2">
                <img src="img/galeria/G3.png" alt="" class="ss-img2">
            </div>
        </div>

        <div class="ss-div">
            <div class="ss-div2">
                <img src="img/galeria/G4.png" alt="" class="ss-img2">
                <img src="img/galeria/G5.png" alt="" class="ss-img2">
            </div>
            <img src="img/galeria/G6.png" alt="" class="ss-img">
        </div>

        <div class="ss-div">
            <div class="ss-div2">
                <img src="img/galeria/G14.png" alt="" class="ss-img2">
                <img src="img/galeria/G13.png" alt="" class="ss-img2">
            </div>
            <div class="ss-div2">
                <img src="img/galeria/G8.png" alt="" class="ss-img2">
                <img src="img/galeria/G9.png" alt="" class="ss-img2">
            </div>
        </div>

        <div class="ss-div">
            <div class="ss-div2">
                <img src="img/galeria/G10.png" alt="" class="ss-img2">
                <img src="img/galeria/G11.png" alt="" class="ss-img2">
            </div>
            <img src="img/galeria/G12.png" alt="" class="ss-img">
        </div>

        <div class="ss-div">
            <div class="ss-div2">
                <img src="img/galeria/G15.png" alt="" class="ss-img2">
                <img src="img/galeria/G16.png" alt="" class="ss-img2">
            </div>
            <img src="img/galeria/G17.png" alt="" class="ss-img">
        </div>

    </section> -->



    <section class="seven-section" id="contacto">
        <img src="img/formas/union.png" alt="" class="ses-img">
        <img src="img/formas/elipse.png" alt="" class="ses-img">
        <div class="ses-div">
            <p class="ses-p"><span>PERSPECTIVAS AÉREAS</span>
                QUE TU PROYECTO NECESITA</p>
        </div>

        <div class="ses-div2">
            <p class="ses-p2">CONTÁCTANOS</p>
            <svg width="120" height="24" viewBox="0 0 120 24" fill="none" stroke="#fff" stroke-width="3" stroke-linecap="round" stroke-linejoin="round">
                <line x1="10" y1="12" x2="110" y2="12" />
                <polyline points="100,6 110,12 100,18" />
            </svg>
            <a href="" class="ses-p2">(871) 432 0047</a>
        </div>
    </section>

    <footer>
        <div class="footer-div">
            <img src="img/logo.png" alt="" class="footer-logo">
            <div class="footer-div2">
                <div class="footer-div3">
                    <a href="" class="footer-a2">DRON TRC</a>
                    <a href="" class="footer-a2">SERVICIOS</a>
                    <a href="" class="footer-a2">PROYECTOS</a>
                    <a href="" class="footer-a2">CONTACTO</a>
                </div>
                <hr class="footer-hr">
                <div class="footer-div4">
                    <div class="footer-div5">
                        <a href="" class="footer-a3" target="_blank"><img src="img/iconos/telefono.png" alt=""> (871) 432 0047</a>
                        <a href="" class="footer-a3" target="_blank"><img src="img/iconos/mail.png" alt=""> hola@drontrc.com</a>
                    </div>
                    <div class="footer-div5">
                        <a href="" class="footer-a4" target="_blank"><img src="img/iconos/insta.png" alt=""></a>
                        <a href="" class="footer-a4" target="_blank"><img src="img/iconos/facebook.png" alt=""></a>
                        <a href="" class="footer-a4" target="_blank"><img src="img/iconos/tiktok.png" alt=""></a>
                    </div>
                </div>
            </div>
        </div>
        <a href="https://awsoftware.mx" class="footer-a" target="_blank">Desarrollado por A W Software</a>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js" integrity="sha384-ndDqU0Gzau9qJ1lfW4pNLlhNTkCfHzAVBReH9diLvGRem5+R9g2FzA8ZGN954O5Q" crossorigin="anonymous"></script>
    <script src="js/scroll-animations.js"></script>
</body>

</html>