$(() => {
    $('#galleriesTable').DataTable({
        processing: true,
        ordering: false,
        ajax: {
            url: './routes/web.php', // Asegúrate que esta ruta sea correcta
            type: 'GET',
            data: function (d) {
                d.REQUEST_URI = '/galleries_en/list'
            },
            dataSrc: 'galleries',
            error: function(xhr, error, code) {
                console.error('Error en AJAX DataTable:', {
                    status: xhr.status,
                    statusText: xhr.statusText,
                    responseText: xhr.responseText,
                    error: error,
                    code: code
                });
                alert('Error al cargar los datos. Revisa la consola para más detalles.');
            }
        },
        columns: [
            { data: 'id' },
            { 
                data: 'img',
                render: function (data, type, row, meta) {
                    return `<div style="width: 100px; height: 100px; display: flex; align-items: center; justify-content: center; overflow: hidden; border-radius: 12px; background: #f3f3f3;">
                        <img src="./resources/images/galleries/${data}" alt="Imagen" style="width: 100%; height: 100%; object-fit: cover; object-position: center; display: block;">
                    </div>`
                } 
            },
            { 
                data: 'name',
                render: function(data, type, row, meta){
                    return row.name && row.name.length > 20 ? row.name.substring(0,20) + '...' : (row.name || '')
                }
            },
            { 
                data: 'place',
                render: function(data, type, row, meta){
                    return row.place && row.place.length > 15 ? row.place.substring(0,15) + '...' : (row.place || '')
                }
            },
            { 
                data: 'date',
                render: function(data, type, row, meta){
                    return row.date && row.date.length > 15 ? row.date.substring(0,15) + '...' : (row.date || '')
                }
            }, 
            {
                data: null,
                render: function (data, type, row, meta) {
                    return row.status ? `<span class="badge text-bg-success">Activo</span>` : '<span class="badge text-bg-danger">Inactivo</span>'
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return `
                    <a class="btn btn-primary" href="?page=edit-gallery&id=${row.id}">
                        <i class="fa-solid fa-pen"></i>
                    </a>
                    ${row.status
                            ? `<button class="btn btn-success" onclick="activateGallery(${row.id},0)">
                        <i class="fa-solid fa-check"></i>
                    </button>`
                            : `<button class="btn btn-danger" onclick="activateGallery(${row.id},1)">
                        <i class="fa-solid fa-x"></i>
                        </button>`}
                    `
                }
            }
        ],
        language: {
            url: 'public/assets/datatables/es-Es.json',
        },
    })
})

function activateGallery(id, status) {
    Swal.fire({
        title: `${status ? 'Activar' : 'Desactivar'} Galería`,
        text: `¿Estás seguro de ${status ? 'Activar' : 'Desactivar'} esta galería?`,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: `${status ? '#198754' : '#dc3545'}`,
        cancelButtonColor: "#808080",
        confirmButtonText: `${status ? 'Activar' : 'Desactivar'}`
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: './routes/web.php', // Cambiado de ../../ a ./
                type: 'POST',
                data: { 
                    REQUEST_URI: '/galleries_en/status', 
                    id: id, 
                    status: status 
                },
                dataType: 'json', // Agregado para asegurar que espera JSON
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Estado actualizado',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#galleriesTable').DataTable().ajax.reload();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                    }
                },
                error: (xhr, status, error) => {
                    console.error('Error completo:', {
                        xhr: xhr,
                        status: status,
                        error: error,
                        responseText: xhr.responseText
                    });
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Hubo un error al procesar la solicitud'
                    });
                }
            })
        }
    });
}