$(function () {

    const toolbarOptions = [
        ['bold', 'italic', 'underline', 'strike'],        
        ['blockquote', 'code-block'],
        ['formula'],
        [{ 'header': 1 }, { 'header': 2 }],               
        [{ 'list': 'ordered'}, { 'list': 'bullet' }, { 'list': 'check' }],
        [{ 'script': 'sub'}, { 'script': 'super' }],      
        [{ 'indent': '-1'}, { 'indent': '+1' }],          
        [{ 'direction': 'rtl' }],                         
        [{ 'size': ['small', false, 'large', 'huge'] }],  
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        [{ 'color': [] }, { 'background': [] }],          
        [{ 'font': [] }],
        [{ 'align': [] }],
        ['clean']                                         
      ];
      
      const quill = new Quill('#editor', {
        modules: {
          toolbar: toolbarOptions
        },
        theme: 'snow'
      });

      const maxLength = 65535;
      quill.on('text-change', function (delta, oldDelta, source) {
        const length = quill.getLength() - 1;
        $('#counter').text(length + ' / ' + maxLength);

        if (length > maxLength) {
            quill.deleteText(maxLength, length - maxLength);
            $('#counter').text(maxLength + ' / ' + maxLength).addClass('text-danger');
        } else {
            $('#counter').removeClass('text-danger');
        }
      });

    FilePond.registerPlugin(
        FilePondPluginImagePreview,
        FilePondPluginFileValidateType,
        FilePondPluginImageResize,
        FilePondPluginImageCrop,
        FilePondPluginFileValidateSize,
        FilePondPluginFilePoster
    );
    const pond = FilePond.create(document.getElementById('img'), {
        instantUpload: false,
        allowProcess: false,
        allowRevert: false,
        labelIdle: 'Arrastra tu imagen aquí o <span class="filepond--label-action">Selecciona</span><br><span class="text-muted" style="font-size:0.95em;">Tamaño recomendado: 1547 x 442 px</span>',
        labelInvalidField: 'Campo inválido',
        labelFileLoading: 'Cargando',
        labelFileLoadError: 'Error al cargar',
        labelFileProcessing: 'Procesando',
        labelFileProcessingComplete: 'Procesado',
        labelFileProcessingAborted: 'Procesamiento cancelado',
        labelFileProcessingError: 'Error al procesar',
        labelFileProcessingRevertError: 'Error al revertir',
        labelFileRemoveError: 'Error al eliminar',
        labelTapToCancel: 'Toca para cancelar',
        labelTapToRetry: 'Toca para reintentar',
        labelTapToUndo: 'Toca para deshacer',
        labelButtonRemoveItem: 'Eliminar',
        labelButtonAbortItemLoad: 'Abortar',
        labelButtonAbortItemProcessing: 'Cancelar',
        labelButtonUndoItemProcessing: 'Deshacer',
        labelButtonRetryItemProcessing: 'Reintentar',
        labelButtonProcessItem: 'Subir',
        labelMaxFileSizeExceeded: 'El archivo es demasiado grande',
        labelMaxFileSize: 'El tamaño máximo del archivo es {filesize}',
        maxFiles: 1,
        acceptedFileTypes: ['image/*'],
        maxFileSize: '1MB',
        imagePreviewHeight: 142,
        imageCropAspectRatio: '1547:442',
        imageResizeTargetWidth: 1547,
        imageResizeTargetHeight: 442,
        styleItemPanelAspectRatio: 0.4,
        styleLoadIndicatorPosition: 'center bottom',
        styleProgressIndicatorPosition: 'right bottom',
        styleButtonRemoveItemPosition: 'left bottom',
        styleButtonProcessItemPosition: 'right bottom',
        server: {
            url: './routes/upload.php',
            method: 'POST',
            withCredentials: false,
            headers: {},
            timeout: 7000,
        }
    });

    $.ajax({
        url: './routes/web.php',
        type: 'GET',
        data: { REQUEST_URI: '/blogs_en/find-by-id', id: $('#id').val() },
        success: (response) => {
            if (response.success) {
                $('#id').val(response.blog.id)
                $('#title').val(response.blog.title)
                $('#status').val(response.blog.status)
            }
            if(response.blog.description) {
                quill.clipboard.dangerouslyPasteHTML(response.blog.description);
            }
            if (response.blog.img) {
                const blogImgUrl = `./resources/images/blogs_en/${response.blog.img}`;
                pond.files = [
                    {
                        source: response.blog.img,
                        options: {
                            type: 'local',
                            metadata: {
                                poster: blogImgUrl
                            }
                        }
                    }
                ];

            }

            
        },
        error: (error) => {
            console.log('Error: ', error)
            Swal.fire({
                icon: 'error',
                title: '¡Error!',
                text: '¡Hubo un error al obtener los datos del blog!'
            }).then(() => {
                window.location.href = '?page=blogs'
            });
        }
    })

    const showError = (input, message) => {
        if (input === '#description') {
            $('#description-error').html(`<span class="text-danger ms-2">${message}</span>`);
        } else {
            $(input).after(`<span class="text-danger ms-2">${message}</span>`);
        }
    }
    
    const clearError = (input) => {
        if (input === '#description') {
            $('#description-error').html('');
        } else {
            $(input).next('.text-danger').remove();
        }
    }

    $('#form').on('submit', (e) => {
        e.preventDefault()
        let hasErrors = false

        const title = $('#title').val()
        const description = quill.getSemanticHTML()
        const status = $('#status').val()

        clearError('#title')
        clearError('#description')
        clearError('#img')
        clearError('#status')

        if (!title) {
            showError('#title', 'El título es requerido')
            hasErrors = true
        } else if (title.lenght > 255) {
            showError('#title', 'El título no puede ser mayor a 255 caracteres')
            hasErrors = true
        }

        if (quill.getText().trim() === '' || quill.getText().trim() === '\n') {
            showError('#description', 'La descripción es requerida')
            hasErrors = true
        }

        if (pond.getFiles().length === 0) {
            showError('#img', 'La imagen es requerida');
            hasErrors = true;
        }

        if (!status) {
            showError('#status', 'El estado es requerido')
            hasErrors = true
        }

        if (hasErrors) return

        pond.processFiles().then(file => {
            const filePond = pond.getFile()
            const formData = {
                id: $('#id').val(),
                title: title,
                description: description,
                img: filePond.serverId,
                status: status
            }

            $.ajax({
                url: './routes/web.php',
                type: 'POST',
                data: { REQUEST_URI: '/blogs_en/update', data: formData, },
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Exito!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            window.location.href = '?page=blogs'
                        });
                    }
                },
                error: (error) => {
                    console.log('Error: ', error)
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Hubo un error al procesar la solicitud'
                    });
                }
            })
        })
    })
})