<?php
require_once __DIR__ . '/../models/Mail.php';

class MailController
{
    public static function send($name, $email, $phone = null)
    {
        try {
            $to = "Cuidadodesi.ra@gmail.com";
            $subject = "New Subscription";

            // Manejar el caso cuando el teléfono esté vacío
            $phoneText = !empty($phone) ? htmlspecialchars($phone) : 'Not provided';

            $message = '<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Nueva suscripción</title>
    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #e0f7fa, #ffffff);
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 480px;
            margin: 60px auto;
            background: #ffffff;
            border-radius: 16px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
            padding: 40px 32px;
        }
        h2 {
            color: #007ea7;
            margin-bottom: 20px;
            font-size: 1.8rem;
            text-align: center;
        }
        p {
            color: #333;
            font-size: 1.1rem;
            line-height: 1.6;
            text-align: center;
        }
        .email {
            color: #007ea7;
            font-weight: bold;
            word-break: break-word;
        }
        .footer {
            margin-top: 36px;
            color: #777;
            font-size: 0.9rem;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>🎉 ¡Nueva suscripción!</h2>
        <p>La persona 
        <span class="name"><b>' . htmlspecialchars($name) . '</b></span> <br>
        con el correo <span class="email"><b>' . htmlspecialchars($email) . '</b></span>
        <br>
        y número de teléfono <span class="phone"><b>' . $phoneText . '</b></span>
        se ha suscrito a tu boletín de noticias.</p>
        <div class="footer">Cuidado de Sí &copy; ' . date('Y') . '</div>
    </div>
</body>
</html>';

            $headers  = "MIME-Version: 1.0\r\n";
            $headers .= "Content-type: text/html; charset=UTF-8\r\n";
            $headers .= "From: Cuidado de Sí <{$to}>\r\n";
            $headers .= "Reply-To: {$to}\r\n";

            $success = Mail::send($to, $subject, $message, $headers);

            echo json_encode([
                'success' => $success,
                'message' => $success ? 'Email sent successfully!' : 'Error sending email'
            ]);
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => 'Exception: ' . $e->getMessage()
            ]);
        }
    }
}