<!-- HERO -->
<div class="container-fluid section-specific-course">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-6 text-center">
                <h1
                    class="text-white fade-in-left"
                    style="font-size: 4rem;">
                    Geometría del Alma
                </h1>
            </div>
        </div>
    </div>
</div>

<!-- INTRO -->
<div class="container py-5 my-5">
    <div class="row align-items-center">
        <div class="col-12 col-lg-6 mb-4 mb-lg-0 d-flex justify-content-center">
            <img
                src="/cuidado/public/assets/images/GEOMETRIA.png"
                alt="geometria"
                class="img-fluid rounded-4"
                style="max-width: 500%;"
                loading="eager" />
        </div>
        <div class="col-12 col-lg-6 course-responsive">
            <p
                class="fw-bold mb-4 fs-5"
                style="text-align: justify;">
                Cada persona posee una geometría interior: patrones que revelan cómo
                pensamos, sentimos y actuamos.
            </p>
            <p
                class="mb-4 fs-5"
                style="text-align: justify;">
                Comprender esta geometría significa descifrar el mapa de tu alma para
                transformarlo en libertad, salud mental y plenitud espiritual.
            </p>
        </div>
    </div>
</div>

<!-- OBJETIVO -->
<div class="my-5 py-5" style="background-color: #f4ece4;">
    <div class="container py-4 my-4">
        <div class="row align-items-center">
            <div class="col-12 col-lg-6 order-2 order-lg-1 course-responsive">
                <h2
                    class="fade-in-left subtitle"
                    style="font-size: 3rem;">
                    🎯 Objetivo del Programa
                </h2>
                <p
                    class="fw-bold mb-4 fs-5"
                    style="text-align: justify;">
                    Geometría del Alma busca que cada persona pueda reconocer los patrones
                    que estructuran su vida, integrar recursos psicológicos y
                    espirituales, y desarrollar una manera más consciente de habitarse a
                    sí mismo, sus relaciones y su entorno.
                </p>
            </div>
            <div
                class="col-12 col-lg-6 order-1 order-lg-2 d-flex justify-content-center mb-4 mb-lg-0">
                <img
                    src="/cuidado/public/assets/images/GEO_1.png"
                    alt="objetivo"
                    class="img-fluid rounded-4"
                    style="max-width: 90%;"
                    loading="lazy" />
            </div>
        </div>
    </div>
</div>

<!-- DIFERENCIAS -->
<div class="container my-5 py-5">
    <div class="row align-items-center">
        <div class="col-12 col-lg-6 mb-4 mb-lg-0 d-flex justify-content-center">
            <img
                src="/cuidado/public/assets/images/GEO_2.png"
                alt="metodologia"
                class="img-fluid rounded-4"
                style="max-width: 90%;"
                loading="lazy" />
        </div>
        <div class="col-12 col-lg-6 course-responsive">
            <h2
                class="fw-bold mb-4 fs-3">
                ¿Por qué Geometría del Alma es diferente?
            </h2>
            <p
                class="fw-bold mb-4 fs-5">
                La mayoría de programas de autoconocimiento se limitan a describir tipos
                de personalidad. Geometría del Alma va más allá porque:
            </p>
            <ul>
                <li
                    class="mb-3 fs-5">
                    🌀 Integra el psicoanálisis para comprender no solo cómo eres, sino
                    por qué actúas así, revelando las raíces inconscientes de tu historia.
                </li>
                <li
                    class="mb-3 fs-5">
                    ✡ Aporta la sabiduría de la tradición judeocristiana, que ilumina la
                    geometría interior con símbolos y claves espirituales de
                    trascendencia.
                </li>
                <li
                    class="mb-3 fs-5">
                    💡 Aplica la Terapia Racional Emotiva, ofreciendo herramientas
                    prácticas para transformar pensamientos limitantes y alcanzar mayor
                    libertad emocional y existencial.
                </li>
                <li
                    class="mb-3 fs-5">
                    🎓 Está dirigido por un facilitador con sólida formación psicológica y
                    espiritual: Ramiro A. Álvarez, Mg. — psicólogo y psicoanalista, con
                    más de 30 años de experiencia en acompañamiento humano y comunitario.
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- DESCUBRE -->
<div class="my-5 py-5" style="background-color: #f4ece4;">
    <div class="container py-4 my-4">
        <div class="row align-items-center">
            <div class="col-12 col-lg-12 course-responsive">
                <h2
                    class="fw-bold mb-4 mt-4 fade-in-up fs-3">
                    ✨ Descubre la geometría de tu alma: del ego al amor
                </h2>
                <p
                    class="fw-bold mt-4 fs-5">
                    Esta combinación convierte a Geometría del Alma en un programa único,
                    profundo y contemporáneo, donde lo psicológico y lo espiritual se unen
                    para una verdadera transformación individual y colectiva.
                </p>

                <h3
                    class="fw-bold mt-4 mb-3 fs-4">
                    🚀 Beneficios de analizar la geometría de tu alma
                </h3>
                <ul>
                    <li class="fs-5">
                        🔍 Autoconocimiento – Conocer tu mapa interno para vivir con
                        autenticidad.
                    </li>
                    <li class="fs-5">
                        🧭 Autoliderazgo – Aprender a dirigir tu vida con claridad y
                        propósito.
                    </li>
                    <li class="fs-5">
                        🤝 Resolución de conflictos – Herramientas para superar diferencias
                        con madurez.
                    </li>
                    <li class="fs-5">
                        🏡 Relaciones familiares – Transformar vínculos en espacios de
                        crecimiento.
                    </li>
                    <li class="fs-5">
                        👥 Equipos de trabajo – Crear comunidades sólidas y colaborativas.
                    </li>
                    <li class="fs-5">
                        🌱 Crecimiento espiritual – Pasar del ego al amor, de la herida a la
                        plenitud.
                    </li>
                </ul>

                <p
                    class="fw-bold mt-4 fs-5">
                    Dirigido a personas de todas las edades que buscan autoconocimiento,
                    sanación interior y crecimiento espiritual.
                </p>
            </div>
        </div>
    </div>
</div>

<!-- METODOLOGÍA -->
<div class="container my-2 py-3">
    <div class="row align-items-center">
        <div class="col-12 col-lg-12 course-responsive">
            <h1
                class="fw-bold mb-4 mt-4 fade-in-up fs-2">
                🎯 Metodología
            </h1>
            <ul>
                <li class="fs-5">
                    Sesiones grupales: aprendizaje compartido y dinámico.
                </li>
                <li class="fs-5">
                    Sesiones familiares: comprensión y transformación de vínculos en el
                    hogar.
                </li>
                <li class="fs-5">
                    Sesiones particulares: acompañamiento personalizado en tu propio
                    proceso.
                </li>
                <li class="fs-5">
                    Integración única de psicoanálisis, sabiduría espiritual y Terapia
                    Racional Emotiva.
                </li>
            </ul>
            <p
                class="fw-bold mt-4 fs-6">
                Dirección académica y espiritual de Ramiro Álvarez, Mg., con formación
                interdisciplinaria y experiencia internacional.
            </p>
            <p
                class="fw-bold mt-4 mb-4 fs-6">
                🚪 Atrévete a entrar en la geometría de tu alma. Un viaje profundo y
                práctico que transforma el ego en amor, el conflicto en crecimiento y la
                búsqueda en plenitud.
            </p>
        </div>
    </div>
</div>

<style>
.section-specific-course{
    place-content: center;
    min-height: 55vh;
    background-image: url('<?php echo $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST']; ?>/cuidado/public/assets/images/BANNER_GEO.png');
    background-position: center;
    background-repeat: no-repeat;
    background-size: cover;
}
</style>