<section class="section-home-one d-flex align-items-center">
    <div class="container">
        <div class="row justify-content-start">
            <div class="col-12 col-md-6 col-lg-5">
                <div class="container-home-one py-5">
                    <h2 class="fs-1 fade-in-left">Self-care is the gateway to caring for the world.</h2>
                    <p class="fade-in-up mt-4">
                        Self-care is an innovative and highly attractive proposal that emerges from the need to unify mental and spiritual health in the human being.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="container inicio section-home-margin">
    <h2 class="h2-title h2-title-margin fade-in-left">HOME</h2>
    <div class="row g-4">
        <div class="col-12 col-md-6">
            <article class="article-cds me-md-5">
                <span class="fade-in-left title">
                    <span class="circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
                    <span class="fs-1 subtitle">Self-Care</span>
                </span>
                <p class="fw-bold fade-in-up">
                    Care is an essential principle that encompasses our relationship with ourselves, with others, and with the environment. It involves an active commitment to the protection and well-being of all living beings. Taking care of ourselves allows us to be in a better position to care for others and the world around us. This includes practices such as meditation, exercise, and healthy eating, which strengthen us both physically and emotionally.
                </p>
                <p class="fade-in-up">
                    Self-care is an innovative and highly attractive proposal that emerges from the need to unify mental health and spirituality in the human being. It is aptly promoted by Ramiro Álvarez, priest and psychotherapist.
                </p>
                <p class="fade-in-up m-0">
                    This approach involves a series of activities that the individual undertakes in order to turn their gaze upon themselves: their thoughts, emotions, actions, and relationships with others. These practices, called "technologies of the self," come from the reflection of the French philosopher Michel Foucault, who explored the concept of self-care as a form of self-knowledge and personal transformation.
                </p>
            </article>
        </div>
        <div class="col-12 col-md-6 m-0">
            <article class="article-mision-vision rounded">
                <h3 class="mb-3 fade-in-left subtitle-size">Mission</h3>
                <p class="mb-5 fade-in-up">
                    <span class="fw-bold">Provide resources and guidance for people to embark on a journey of personal transformation through self-care.</span> We are committed to offering quality content that inspires reflection and spiritual, emotional, and intellectual development, promoting a balanced and meaningful life.
                </p>
                <h3 class="mb-3 fade-in-right subtitle-size">Vision</h3>
                <p class="fade-in-up m-0">
                    <span class="fw-bold">To be leaders in comprehensive self-care</span>, empowering people to transform their lives through self-knowledge, self-discipline, and personal development, promoting a community committed to their own well-being and that of their environment.
                </p>
            </article>
        </div>
    </div>
</div>
<div class="section-bio" id="biografia">
    <div class="container">
        <div class="row align-items-start">
            <div class="col-12 col-md-6 d-flex justify-content-center align-items-start mb-4 mb-md-0">
                <img src="../public/assets/images/home/BIOGRAFIA.png" alt="Photo of Ramiro Álvarez" class="img-fluid rounded-4" style="object-fit:cover;" loading="eager">
            </div>
            <div class="col-12 col-md-6">
                <h2 class="h2-title fade-in-left">BIOGRAPHY</h2>
                <span class="fade-in-left title">
                    <span class="circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
                    <span class="fs-1 subtitle">Fr. Ramiro Álvarez</span>
                </span>
                <div class="b-rounded fade-in-up">
                    <p class="px-4 py-1 fade-in-up">Philosopher, theologian and psychologist</p>
                </div>
                <p class="fw-bold fade-in-up">
                    Ramiro A. Álvarez was born in Colombia. He holds degrees in Philosophy, Theology, and Psychology, and has a master's degree in Human Resources and Organizational Behavior from the Pontifical Catholic University of Chile.
                </p>
                <p class="fade-in-up">
                    With more than 29 years of experience, he has given conferences, workshops, and courses internationally, work that he complements with his vocation as a priest and therapist.
                </p>
                <p class="fade-in-up">
                    Throughout his career, he has developed research in psychoanalysis, Sacred Scripture, learning problems, and organizational leadership. His solid academic training and vast experience have consolidated him as a reference at the intersection between science and spirituality, addressing both fields from a transdisciplinary perspective.
                </p>
                <p class="fade-in-up">
                    His most recent project, Self-Care (cuidadodesi.com), seeks to promote a comprehensive approach that inspires personal growth through spirituality, self-knowledge, and the development of emotional intelligence.
                </p>
            </div>
        </div>
    </div>
</div>
<section class="section-services d-flex justify-content-center align-items-center">
    <div class="container section-home-margin">
        <div class="text-center border-bottom pb-4">
            <h2 class="fs-5 fade-in-up subtitle-size">SERVICES</h2>
        </div>
        <div class="row g-4 mt-5">
            <!-- Conferences -->
            <div class="col-12 col-md-4">
                <article class="article-service h-100 d-flex flex-column">
                    <div>
                        <img src="../public/assets/images/CONFERENCIAS.png" alt="Conferences"
                            class="img-fluid rounded-4" style="object-fit:cover; height:250px;" loading="eager">
                        <h3 class="fade-in-left subtitle-size mb-0 mt-5">Conferences</h3>
                        <div class="container-p mt-5">
                            <p class="fade-in-left"><span class="fw-bold">Mind, body and spirit</span>: the path to inner harmony.</p>
                            <p class="fade-in-left">Adolescence, opportunity or challenge?</p>
                            <p class="fade-in-left"><span class="fw-bold">Re-thinking grief</span>: From pain to learning.</p>
                        </div>
                    </div>
                    <a href="?page=services" class="btn btn-light rounded-4 mt-5">See more</a>
                </article>
            </div>

            <!-- Courses and workshops -->
            <div class="col-12 col-md-4">
                <article class="article-service h-100 d-flex flex-column">
                    <div>
                        <img src="../public/assets/images/CURSOS Y TALLERES.png" alt="Courses and workshops"
                            class="img-fluid rounded-4" style="object-fit:cover; height:250px;" loading="eager">
                        <h3 class="fade-in-up subtitle-size mb-0 mt-5">Courses and workshops</h3>
                        <div class="container-p mt-5">
                            <a href="?page=curso" class="fw-bold fade-in-up" style="color: white;">Geometry of the Soul</a>
                        </div>
                    </div>
                    <a href="?page=services" class="btn btn-light rounded-4 mt-5">See more</a>
                </article>
            </div>

            <!-- Therapy -->
            <div class="col-12 col-md-4">
                <article class="article-service h-100 d-flex flex-column">
                    <div>
                        <img src="../public/assets/images/TERAPIA.png" alt="Therapy"
                            class="img-fluid rounded-4" style="object-fit:cover; height:250px;" loading="eager">
                        <h3 class="fade-in-right subtitle-size mb-0 mt-5">Therapy</h3>
                        <div class="container-p mt-5">
                            <p class="fw-bold fade-in-right">Online</p>
                            <p class="fw-bold fade-in-right">In person</p>
                        </div>
                    </div>
                    <a href="?page=services" class="btn btn-light rounded-4 mt-5">See more</a>
                </article>
            </div>
        </div>
    </div>
</section>


<div class="container section-home-margin" id="galeria">
    <h2 class="h2-title fade-in-left">GALLERY</h2>
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h2 class="fade-in-left">
            <span class="align-middle circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
            <span class="align-middle subtitle">Recent Events</span>
        </h2>
        <div class="d-flex justify-content-around align-items-center">
            <button type="button" class="btn-arrow me-3" id="prev">
                <i class="fa-solid fa-arrow-left fa-lg"></i>
            </button>
            <button type="button" class="btn-arrow" id="next">
                <i class="fa-solid fa-arrow-right fa-lg"></i>
            </button>
        </div>
    </div>
    <div class="row row-cols-1 row-cols-md-3 g-3" id="recent_events">
    </div>
</div>
<div class="container section-home-margin" id="eventos">
    <h2 class="h2-title fade-in-left">EVENTS</h2>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="m-0 fade-in-left">
            <span class="align-middle circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
            <span class="align-middle subtitle">Upcoming Events</span>
        </h2>
        <div class="d-flex justify-content-around align-items-center">
            <button type="button" class="btn-arrow me-3" id="prev_events">
                <i class="fa-solid fa-arrow-left fa-lg"></i>
            </button>
            <button type="button" class="btn-arrow" id="next_events">
                <i class="fa-solid fa-arrow-right fa-lg"></i>
            </button>
        </div>
    </div>
    <div class="container-events d-flex flex-column justify-content-end align-items-end p-4 position-relative">
        <div class="bg-image"></div>
        <div class="overlay"></div>
        <div class="contenido position-relative" style="width: 35%;">
            <div class="text-white d-flex flex-column mb-4">
                <div class="mb-4">
                    <span class="fw-bold fs-3" id="event_name">Event</span>
                </div>
                <div class="mb-2">
                    <i class="fa-solid fa-calendar-days"></i>
                    <span class="ms-2" id="event_date">May 25</span>
                </div>
                <div>
                    <i class="fa-solid fa-location-dot"></i>
                    <span class="ms-2" id="event_place">Monterrey</span>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container section-home-margin videos_responsive" id="videos">
    <h2 class="h2-title fade-in-left">VIDEOS</h2>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="fade-in-left">
            <span class="align-middle circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
            <span class="align-middle subtitle">Find us on YouTube</span>
        </h2>
        <div class="d-flex justify-content-around align-items-center">
            <button type="button" class="btn-arrow me-3" id="prev_videos">
                <i class="fa-solid fa-arrow-left fa-lg"></i>
            </button>
            <button type="button" class="btn-arrow" id="next_videos">
                <i class="fa-solid fa-arrow-right fa-lg"></i>
            </button>
        </div>
    </div>
    <div class="row row-cols-1 row-cols-md-2 g-4 videos" id="videosVal">
    </div>
</div>
<div class="section-home-two d-flex justify-content-start align-items-center">
    <div class="container py-5">
        <div class="d-flex flex-column justify-content-center align-items-center">
            <div>
                <span class="fade-in-left title one" style="font-size: 4rem;">Transform your life</span>
            </div>
            <div class="mt-3">
                <span class="fade-in-left title two" style="font-size: 6rem;">from within</span>
            </div>
        </div>
    </div>
</div>
<div class="container section-home-margin section-blog">
    <div class="row">
        <div class="col-12 col-md-6 d-flex justify-content-center align-items-start mb-4 mb-md-0">
            <img src="../public/assets/images/home/BLOG.png" alt="blog" class="img-fluid rounded-4" style="object-fit:cover;" loading="lazy">
        </div>
        <div class="col-12 col-md-6">
            <h2 class="h2-title fade-in-left">BLOG</h2>
            <span class="fade-in-left title">
                <span class="circle-responsive" style="color: #19b0df; font-size: 3rem;">●</span>
                <span class="fs-1 subtitle">Guide for your well-being</span>
            </span>
            <p class="fw-bold fade-in-up" style="text-align: justify;">
                A human being who takes care of themselves is someone who loves and respects their environment. By integrating these concepts into our daily lives, we can move toward a more balanced and harmonious lifestyle.
            </p>
            <p class="fade-in-up" style="text-align: justify;">
                Care, sustainability, sensitive reason, ecology -both inner and outer- and biophilia offer us a holistic framework to face the challenges of the present and build a healthier and more just future.
            </p>
            <p class="fade-in-up" style="text-align: justify;">
                Adopting these principles not only favors our personal well-being, but also contributes to the well-being of our community and the planet. In this way, together we can create a world in which living in harmony with ourselves, with others, and with nature is a tangible reality.
            </p>
        </div>
    </div>
</div>
<div class="container section-home-margin section-blog-list">
    <h2 class="mb-4 fade-in-left subtitle">Blog</h2>
    <div class="row g-4 mb-5" id="alert">
        <div class="col-12 col-md-6">
            <div class="h-100" id="recent_blog">
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="row g-4" id="blogs">
            </div>
        </div>
    </div>
    <div class="d-flex justify-content-center mt-5">
        <?php
        // Detectar el idioma actual de manera más robusta
        $current_path = $_SERVER['REQUEST_URI'] ?? '';
        $is_english = strpos($current_path, '/en/') !== false;
        ?>
        <a href="?page=blog" class="btn rounded-4 text-white fw-semibold btn-lg px-5" style="background-color: #19b0df;">
            More Blogs
        </a>
    </div>
</div>
<div class="gallery-images" id="gallery-images">
    <div class="container-fluid d-flex flex-column justify-content-center align-items-center py-5" style="height: 100%;">
        <div id="galleryCarousel" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-inner" id="gallery_carousel_inner">
            </div>
            <button id="carousel-prev" class="carousel-control-prev" type="button" data-bs-target="#galleryCarousel" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button id="carousel-next" class="carousel-control-next" type="button" data-bs-target="#galleryCarousel" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
        <div class="text-center text-white mt-4 px-4" id="gallery_detail">
        </div>
    </div>
</div>