<?php
require_once __DIR__ . '/../models/Video.php';
header('Content-Type: application/json');   
class VideoController
{
    public static function index($status){
        $videos = Video::all($status);
        echo json_encode([
            'success' => true,
            'message' => '¡Videos obtenidos con exito!',
            'videos' => $videos
        ]);
    }
    public static function store($link){
        if(Video::create($link)){
            echo json_encode([
                'success' => true,
                'message' => '¡Video creado correctamente!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => '¡Error al crear el video!'
            ]);
        }
    }

    public static function show($id){
        $video = Video::findById($id);
        echo json_encode([
            'success' => true,
            'message' => 'Video encontrado correctamente',
            'video' => $video
        ]);
    }

    public static function update(int $id, $link, $status)
    {
        if(Video::update($id,['link'=>$link, 'status'=>$status])){
            echo json_encode([
                'success' => true,
                'message' => '¡Video actualizado correctamente!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => '¡Error al actualizar el video!'
            ]);
        }
    }

    public static function status(int $id, $status)
    {
        if(Video::update($id,['status'=>$status])){
            echo json_encode([
                'success' => true,
                'message' => '¡Video actualizado correctamente!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => '¡Error al actualizar el video!'
            ]);
        }
    }
}